<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    
    <title>Website Security Checker | Malware Scan | Astrolabe SiteCheck</title>

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

   
    <meta itemprop="name" content="Astrolabe SiteCheck - Free Website Security Check &amp; Malware Scanner">
    <meta itemprop="description" content="SiteCheck is a website security scanner that checks any link or URL for malware, viruses, blacklist status, or malicious code. Check your website safety for free with Astrolabe..">

    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin="">
    <link href="dashboard-resources//css" rel="stylesheet">

    <link rel="stylesheet" href="dashboard-resources//styles.min.css">
    <script src="dashboard-resources//utag.js.download" type="text/javascript" async=""></script><script src="dashboard-resources//scripts.min.js.download"></script>

    
</head>

<body><div id="olark" style="display: none;"><olark><iframe frameborder="0" id="olark-loader" src="dashboard-resources//saved_resource.html"></iframe></olark></div>
    <script type="text/javascript"> (function (a, b, c, d) { a = '//tags.tiqcdn.com/utag/gpl/Astrolabe/' + ('sitecheck.Astrolabe.net' === location.host ? 'prod' : 'dev') + '/utag.js'; b = document; c = 'script'; d = b.createElement(c); d.src = a; d.type = 'text/java' + c; d.async = true; a = b.getElementsByTagName(c)[0]; a.parentNode.insertBefore(d, a) })(); </script>
    <!-- App Header -->

    <header class="app-header py-4 bg-gray-1b">
        <div class="w-full container mx-auto flex justify-between items-center">
            <div class="flex items-center lg:mr-4 xl:mr-25">
                <a target="_blank" class="logo inline-flex mr-auto" href="index.php">
                <img src="resources/logo.png" >

                </a>
            </div>

            <div class="nav-wrapper hidden w-full lg:flex flex-row justify-between items-center">
                <nav class="primary-nav flex flex-row">
                </nav>

                <nav class="secondary-nav flex flex-row">
                   
                    <a  class="support text-white whitespace-nowrap capitalize px-4 xl:px-12 py-4 ml-4 xl:ml-50 leading-none text-sm  hover:bg-gray-midnight" href="#">Dashboard</a>
                    <a  class="support text-white whitespace-nowrap capitalize px-4 xl:px-12 py-4 ml-4 xl:ml-50 leading-none text-sm  hover:bg-gray-midnight" href="order.php">Subscription</a>
					 <a  class="support text-white whitespace-nowrap capitalize px-4 xl:px-12 py-4 ml-4 xl:ml-50 leading-none text-sm  hover:bg-gray-midnight" href="profile.php">Account Setting</a>
                    <a  class="support text-white whitespace-nowrap capitalize px-4 xl:px-12 py-4 ml-4 xl:ml-50 leading-none text-sm bg-green hover:bg-gray-midnight" href="index.php">Logout</a>
                </nav>
            </div>
        </div>
    </header>

    <div class="w-full main">
        <section class="w-full text-center mt-50 md:mt-100" id="homepage">
            <div class="container">
                <div class="w-full p-25 md:p-50 bg-white rounded-2xl" id="scanhome">
                    <h1 class="text-green text-4xl lg:text-40 xl:text-50 leading-none">Free website malware and security checker</h1>
                    <p class="text-lg md:text-xl my-10 font-normal">Enter a URL like example.com and the Astrolabe SiteCheck scanner will check the website for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code.</p>

                    <div class="text-red medium-text pb-9 clearfix" style="display:none" id="formerror"></div>
                    <noscript>
                        <div class="text-red medium-text pb-9 clearfix">This website requires JavaScript. Please enable JavaScript in your browser.</div>
                    </noscript>
                    <form action="result.php" method="get" class="w-full flex flex-col md:flex-row items-stretch" id="scanform" >
                        <input placeholder="example.com" readonly value="KPCIP.PK" type="text" name="scan" id="websiteurl" class="rounded-none text-xl py-4 w-full px-8 border-2 border-green focus:outline-none" autofocus="">

                        <button class="auto-track bg-green hover:bg-gray-midnight rounded-none text-2xl font-bold px-14 py-4 whitespace-nowrap text-white" data-gatrack="Button_Click, Scan_Website" type="submit">Submit</button>
                    </form>

                </div>
            </div>

            <div class="container mt-5">
                <div class="w-full">
                    <p class="text-base leading-6 text-gray-dark">
                        <strong>Disclaimer:</strong> Astrolabe SiteCheck is a free website security scanner. Remote scanners have limited access and results are not guaranteed.<br> For a full website scan at the client and server levels, <a href="https://Astrolabe.net/company/contact-us/" target="_blank">contact our team.</a>
                    </p>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50 leading-none">Website protection you can depend on.</h2>
                </div>

                <div class="products-row grid lg:grid-cols-3 mt-25 md:mt-60 gap-6 lg:gap-25 xl:gap-50">
                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                                <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"></path>
                                <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"></path>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip right-0">The Astrolabe Platform continuously scans your website and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                <br><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>
                        <h3 class="text-gray-midnight text-2xl font-bold">Website Monitoring</h3>
                        <p class="text-lg mt-2 mb-10">Malware removal and hack repair (response)</p>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                                <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                                  <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"></path>
                                  <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"></path>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops website hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Website Firewall</h3>
                        <p class="text-lg mt-2 mb-10">Protect and speed up<br> your site</p>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.268" height="50.2" viewBox="0 0 50.268 50.2">
                                <g id="Group_711" data-name="Group 711" transform="translate(-1327.676 -1939)">
                                  <rect id="Rectangle_556" data-name="Rectangle 556" width="50.254" height="5.017" transform="translate(1327.676 1953.366)" fill="#1b262c"></rect>
                                  <rect id="Rectangle_557" data-name="Rectangle 557" width="50.254" height="5.017" transform="translate(1327.676 1969.277)" fill="#1b262c"></rect>
                                  <path id="Path_1139" data-name="Path 1139" d="M4.08,4.014H46.254V46.188H4.08ZM.067,50.2h50.2V0H.067Z" transform="translate(1327.677 1938.999)" fill="#1b262c"></path>
                                  <rect id="Rectangle_558" data-name="Rectangle 558" width="10.069" height="4.014" transform="translate(1335.623 1947.117)" fill="#028673"></rect>
                                  <rect id="Rectangle_559" data-name="Rectangle 559" width="10.069" height="4.014" transform="translate(1335.623 1962.093)" fill="#028673"></rect>
                                  <rect id="Rectangle_560" data-name="Rectangle 560" width="10.069" height="4.014" transform="translate(1335.623 1977.068)" fill="#028673"></rect>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br>
                                <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                        <p class="text-lg mt-2 mb-10">Get rid of malware and clean up a hacked site</p>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50">How SiteCheck detects viruses and <br>security threats.</h2>
                </div>

                <div class="app-descriptions mt-8 md:mt-60  bg-white rounded-2xl p-8 md:py-50 md:px-24 grid lg:grid-cols-2 gap-6 md:gap-50">
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                                <defs>
                                  <clippath id="clip-path">
                                    <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"></rect>
                                  </clippath>
                                </defs>
                                <g id="Group_593" data-name="Group 593" transform="translate(0)">
                                  <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.107 2.144)" fill="#008673"></path>
                                  <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" transform="translate(0 0)" fill="#1b262c"></path>
                                  <g id="Group_592" data-name="Group 592" transform="translate(0 0)">
                                    <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                                      <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                    </g>
                                  </g>
                                </g>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Scan Website For Malware &amp; Viruses</h2>
                            <p class="text-xl text-gray-midnight mt-3">Detect malicious code and infected file locations by scanning your external website source code.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto"><svg id="Group_589" data-name="Group 589" xmlns="http://www.w3.org/2000/svg" width="50.051" height="50.051" viewBox="0 0 50.051 50.051">
                            <path id="Path_1112" data-name="Path 1112" d="M5,33.319V16.732L16.732,5H33.318L45.046,16.732V33.319L33.318,45.047H16.732ZM14.659,0,0,14.659V35.391L14.659,50.051H35.39l14.66-14.659V14.659L35.39,0Z" fill="#1b262c"></path>
                            <path id="Path_1113" data-name="Path 1113" d="M25.011,32.022l-7.017-7,7.017-7.033,7.017,7.033Z" transform="translate(0.014 0.014)" fill="#008673"></path>
                          </svg>
                          </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Check Website Blacklist Status</h2>
                            <p class="text-xl text-gray-midnight mt-3">See if your website is blacklisted by website security authorities such as Google, PhishTank, etc.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_594" data-name="Group 594" xmlns="http://www.w3.org/2000/svg" width="50.667" height="50.602" viewBox="0 0 50.667 50.602">
                                <path id="Path_1122" data-name="Path 1122" d="M25.333,11.318l17.13,34.216H8.2ZM25.333,0,0,50.6H50.667Z" fill="#1b262c"></path>
                                <path id="Path_1123" data-name="Path 1123" d="M25.093,40.606l-7.105-7.088L25.093,26.4,32.2,33.518Z" transform="translate(0.24 0.352)" fill="#008673"></path>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Find Out-of-Date Software &amp; Plugins</h2>
                            <p class="text-xl text-gray-midnight mt-3">Identify if your website is running an outdated CMS or vulnerable plugins and extensions.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_590" data-name="Group 590" xmlns="http://www.w3.org/2000/svg" width="48.438" height="48.437" viewBox="0 0 48.438 48.437">
                                <path id="Path_1114" data-name="Path 1114" d="M24.8,36.573,18,29.8,24.8,22.989,31.59,29.8Z" transform="translate(-0.563 -0.719)" fill="#008673"></path>
                                <path id="Path_1115" data-name="Path 1115" d="M4.844,14.531h38.75V43.594H4.844Zm38.75-4.844H0v38.75H48.437V9.687ZM0,4.844H4.844V0H0Zm9.687,0H48.438V0H9.687Z" fill="#1b262c"></path>
                              </svg>
                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Detect Website Security Issues</h2>
                            <p class="text-xl text-gray-midnight mt-3">Check your website for security anomalies, configuration issues, and security recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">Why use a website checker?</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Regularly monitoring your site for malware and indicators of compromise can help you keep tabs on your website’s security and focus your perspective to identify security related issues. Quick response to threats help maintain SEO rankings, organic traffic, brand reputation, and protect website visitors from harm.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">How to check if a website is safe.</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Scanning a website’s source code for malicious links, redirects, iframes, JavaScript, or spam can help you determine if a website is not safe to use. Run a web safety check with SiteCheck to scan for any viruses or malware for a specific URL. A quick remote malware scan can help you pinpoint any configuration issues or security anomalies at the client level.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100 mb-50 md:mb-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50 text-left md:text-center">About Astrolabe</h3>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">What is Astrolabe SiteCheck?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">The SiteCheck scanner remotely checks any URL for security threats, malware, defacements, out-of-date CMS, blacklisting, and other important security issues. It visits a website like an everyday user would to verify the source code for malicious behavior or security anomalies.</p>
                    <p class="text-lg md:text-xl mt-6 text-left">Since the remote scanner only has access to what’s visible on the browser level, it will not detect anything on the server-side. To scan every file in a website’s directory and detect phishing pages, backdoors, mailers, DoS scripts or any other malware at the server level enable the <a href="https://Astrolabe.net/website-security-platform/" target="_blank" class="underline">Astrolabe Platform.</a></p>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">Is Astrolabe SiteCheck safe?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">SiteCheck helps millions of webmasters every year by providing free remote website scanning for security issues. Astrolabe’s SiteCheck monitoring is powered by a highly technical team of security professionals distributed around the world. Our trained security team is skilled at identifying issues and cleaning up hacked websites.</p>
                </div>
            </div>

        </section>

        <section class="w-full text-center mt-50 md:mt-100" id="wordpress-homepage">
            <div class="container">
                <div class="w-full p-25 md:p-50 bg-white rounded-2xl" id="wp-scanhome">
                    <h1 class="text-green text-4xl lg:text-40 xl:text-50 leading-none">Free WordPress malware and security checker</h1>
                    <p class="text-lg md:text-xl my-10 font-normal">Enter a URL like example.com and the Astrolabe SiteCheck scanner will check the WordPress site for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code.</p>

                    <div class="text-red medium-text pb-9 clearfix" style="display:none" id="formerror"></div>
                    <noscript>
                        <div class="text-red medium-text pb-9 clearfix">This website requires JavaScript. Please enable JavaScript in your browser.</div>
                    </noscript>
                    <form action="https://sitecheck.Astrolabe.net/" method="get" class="w-full flex flex-col md:flex-row items-stretch" id="wp-scanform" onsubmit="return onSubmitScanForm(event)">
                        <input placeholder="example.com" type="text" name="scan" id="wp-websiteurl" class="rounded-none text-xl py-4 w-full px-8 border-2 border-green focus:outline-none" autofocus="">

                        <button class="auto-track bg-green hover:bg-gray-midnight rounded-none text-2xl font-bold px-14 py-4 whitespace-nowrap text-white" data-gatrack="Button_Click, Scan_Website" type="submit">Submit</button>
                    </form>

                </div>
            </div>

            <div class="container mt-5">
                <div class="w-full">
                    <p class="text-base leading-6 text-gray-dark">
                        <strong>Disclaimer:</strong> Astrolabe SiteCheck is a free WordPress site security scanner. Remote scanners have limited access and results are not guaranteed.<br> For a full website scan at the client and server levels, <a href="https://Astrolabe.net/company/contact-us/" target="_blank">contact our team.</a>
                    </p>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl md:text-5xl leading-none">WordPress protection you can depend on.</h2>
                </div>

                <div class="products-row grid lg:grid-cols-3 mt-8 md:mt-60 gap-6 md:gap-50">
                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                                <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"></path>
                                <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"></path>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip right-0">The Astrolabe Platform continuously scans your WordPress site and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                <br><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>
                        <h3 class="text-gray-midnight text-2xl font-bold">WordPress Monitoring</h3>
                        <p class="text-lg mt-2 mb-10">Find and identify malware and issues on your site</p>
                        <a href="https://Astrolabe.net/malware-detection-scanning/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" target="_blank" data-gatrack="Button_Click, Remove_Malware">Detect Malware</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                                <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                                  <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"></path>
                                  <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"></path>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops WordPress site hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">WordPress Firewall</h3>
                        <p class="text-lg mt-2 mb-10">Protect and speed up<br> your site</p>
                        <a href="https://Astrolabe.net/website-hack-protection/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Protect_Your_Site" target="_blank">Protect Your Site</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.268" height="50.2" viewBox="0 0 50.268 50.2">
                                <g id="Group_711" data-name="Group 711" transform="translate(-1327.676 -1939)">
                                  <rect id="Rectangle_556" data-name="Rectangle 556" width="50.254" height="5.017" transform="translate(1327.676 1953.366)" fill="#1b262c"></rect>
                                  <rect id="Rectangle_557" data-name="Rectangle 557" width="50.254" height="5.017" transform="translate(1327.676 1969.277)" fill="#1b262c"></rect>
                                  <path id="Path_1139" data-name="Path 1139" d="M4.08,4.014H46.254V46.188H4.08ZM.067,50.2h50.2V0H.067Z" transform="translate(1327.677 1938.999)" fill="#1b262c"></path>
                                  <rect id="Rectangle_558" data-name="Rectangle 558" width="10.069" height="4.014" transform="translate(1335.623 1947.117)" fill="#028673"></rect>
                                  <rect id="Rectangle_559" data-name="Rectangle 559" width="10.069" height="4.014" transform="translate(1335.623 1962.093)" fill="#028673"></rect>
                                  <rect id="Rectangle_560" data-name="Rectangle 560" width="10.069" height="4.014" transform="translate(1335.623 1977.068)" fill="#028673"></rect>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br>
                                <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                        <p class="text-lg mt-2 mb-10">Get rid of malware and clean up a hacked site</p>
                        <a href="https://Astrolabe.net/website-security-platform/help-now/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Backup_Your_Site" target="_blank">Remove Malware</a>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50">How SiteCheck detects viruses and <br>security threats.</h2>
                </div>

                <div class="app-descriptions mt-8 md:mt-60  bg-white rounded-2xl p-8 md:py-50 md:px-24 grid lg:grid-cols-2 gap-6 md:gap-50">
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                                <defs>
                                  <clippath id="clip-path">
                                    <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"></rect>
                                  </clippath>
                                </defs>
                                <g id="Group_593" data-name="Group 593" transform="translate(0)">
                                  <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.107 2.144)" fill="#008673"></path>
                                  <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" transform="translate(0 0)" fill="#1b262c"></path>
                                  <g id="Group_592" data-name="Group 592" transform="translate(0 0)">
                                    <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                                      <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                    </g>
                                  </g>
                                </g>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Scan WordPress For Malware &amp; Viruses</h2>
                            <p class="text-xl text-gray-midnight mt-3">Detect malicious code and infected file locations by scanning your external WordPress site source code.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto"><svg id="Group_589" data-name="Group 589" xmlns="http://www.w3.org/2000/svg" width="50.051" height="50.051" viewBox="0 0 50.051 50.051">
                            <path id="Path_1112" data-name="Path 1112" d="M5,33.319V16.732L16.732,5H33.318L45.046,16.732V33.319L33.318,45.047H16.732ZM14.659,0,0,14.659V35.391L14.659,50.051H35.39l14.66-14.659V14.659L35.39,0Z" fill="#1b262c"></path>
                            <path id="Path_1113" data-name="Path 1113" d="M25.011,32.022l-7.017-7,7.017-7.033,7.017,7.033Z" transform="translate(0.014 0.014)" fill="#008673"></path>
                          </svg>
                          </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Check WordPress Blacklist Status</h2>
                            <p class="text-xl text-gray-midnight mt-3">See if your WordPress site is blacklisted by website security authorities such as Google, PhishTank, etc.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_594" data-name="Group 594" xmlns="http://www.w3.org/2000/svg" width="50.667" height="50.602" viewBox="0 0 50.667 50.602">
                                <path id="Path_1122" data-name="Path 1122" d="M25.333,11.318l17.13,34.216H8.2ZM25.333,0,0,50.6H50.667Z" fill="#1b262c"></path>
                                <path id="Path_1123" data-name="Path 1123" d="M25.093,40.606l-7.105-7.088L25.093,26.4,32.2,33.518Z" transform="translate(0.24 0.352)" fill="#008673"></path>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Find Out-of-Date Software &amp; Plugins</h2>
                            <p class="text-xl text-gray-midnight mt-3">Identify if your WordPress site is running an outdated CMS or vulnerable plugins and extensions.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_590" data-name="Group 590" xmlns="http://www.w3.org/2000/svg" width="48.438" height="48.437" viewBox="0 0 48.438 48.437">
                                <path id="Path_1114" data-name="Path 1114" d="M24.8,36.573,18,29.8,24.8,22.989,31.59,29.8Z" transform="translate(-0.563 -0.719)" fill="#008673"></path>
                                <path id="Path_1115" data-name="Path 1115" d="M4.844,14.531h38.75V43.594H4.844Zm38.75-4.844H0v38.75H48.437V9.687ZM0,4.844H4.844V0H0Zm9.687,0H48.438V0H9.687Z" fill="#1b262c"></path>
                              </svg>
                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Detect WordPress Security Issues</h2>
                            <p class="text-xl text-gray-midnight mt-3">Check your WordPress site for security anomalies, configuration issues, and security recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">Why use a WordPress checker?</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Regularly monitoring your site for malware and indicators of compromise can help you keep tabs on your WordPress site’s security and focus your perspective to identify security related issues. Quick response to threats help maintain SEO rankings, organic traffic, brand reputation, and protect website visitors from harm.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">How to check if a WordPress website is safe.</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Scanning a WordPress site’s source code for malicious links, redirects, iframes, JavaScript, or spam can help you determine if a WordPress site is not safe to use. Run a web safety check with SiteCheck to scan for any viruses or malware for a specific URL. A quick remote malware scan can help you pinpoint any configuration issues or security anomalies at the client level.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100 mb-50 md:mb-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50 text-left md:text-center">About Astrolabe</h3>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">What is Astrolabe SiteCheck?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">The SiteCheck scanner remotely checks any URL for security threats, malware, defacements, out-of-date CMS, blacklisting, and other important security issues. It visits a WordPress site like an everyday user would to verify the source code for malicious behavior or security anomalies.</p>
                    <p class="text-lg md:text-xl mt-6 text-left">Since the remote scanner only has access to what’s visible on the browser level, it will not detect anything on the server-side. To scan every file in a website’s directory and detect phishing pages, backdoors, mailers, DoS scripts or any other malware at the server level enable the <a href="https://Astrolabe.net/website-security-platform/" target="_blank" class="underline">Astrolabe Platform.</a></p>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">Is Astrolabe SiteCheck safe?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">SiteCheck helps millions of webmasters every year by providing free remote WordPress site scanning for security issues. Astrolabe’s SiteCheck monitoring is powered by a highly technical team of security professionals distributed around the world. Our trained security team is skilled at identifying issues and cleaning up hacked WordPress sites.</p>
                </div>
            </div>

        </section>

        <section class="w-full text-center mt-50 md:mt-100" id="joomla-homepage">
            <div class="container">
                <div class="w-full p-25 md:p-50 bg-white rounded-2xl" id="joomla-scanhome">
                    <h1 class="text-green text-4xl lg:text-40 xl:text-50 leading-none">Free Joomla! malware and security checker</h1>
                    <p class="text-lg md:text-xl my-10 font-normal">Enter a URL like example.com and the Astrolabe SiteCheck scanner will check the Joomla! site for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code.</p>

                    <div class="text-red medium-text pb-9 clearfix" style="display:none" id="formerror"></div>
                    <noscript>
                        <div class="text-red medium-text pb-9 clearfix">This website requires JavaScript. Please enable JavaScript in your browser.</div>
                    </noscript>
                    <form action="https://sitecheck.Astrolabe.net/" method="get" class="w-full flex flex-col md:flex-row items-stretch" id="joomla-scanform" onsubmit="return onSubmitScanForm(event)">
                        <input placeholder="example.com" type="text" name="scan" id="joomla-websiteurl" class="rounded-none text-xl py-4 w-full px-8 border-2 border-green focus:outline-none" autofocus="">

                        <button class="auto-track bg-green hover:bg-gray-midnight rounded-none text-2xl font-bold px-14 py-4 whitespace-nowrap text-white" data-gatrack="Button_Click, Scan_Website" type="submit">Submit</button>
                    </form>

                </div>
            </div>

            <div class="container mt-5">
                <div class="w-full">
                    <p class="text-base leading-6 text-gray-dark">
                        <strong>Disclaimer:</strong> Astrolabe SiteCheck is a free Joomla! site security scanner. Remote scanners have limited access and results are not guaranteed.<br> For a full website scan at the client and server levels, <a href="https://Astrolabe.net/company/contact-us/" target="_blank">contact our team.</a>
                    </p>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl md:text-5xl leading-none">Joomla! protection you can depend on.</h2>
                </div>

                <div class="products-row grid lg:grid-cols-3 mt-25 md:mt-60 gap-6 md:gap-50">
                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                                <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"></path>
                                <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"></path>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip right-0">The Astrolabe Platform continuously scans your Joomla! site and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                <br><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>
                        <h3 class="text-gray-midnight text-2xl font-bold">Joomla! Monitoring</h3>
                        <p class="text-lg mt-2 mb-10">Find and identify malware and issues on your site</p>
                        <a href="https://Astrolabe.net/malware-detection-scanning/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" target="_blank" data-gatrack="Button_Click, Remove_Malware">Detect Malware</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                                <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                                  <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"></path>
                                  <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"></path>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops Joomla! site hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Joomla! Firewall</h3>
                        <p class="text-lg mt-2 mb-10">Protect and speed up<br> your site</p>
                        <a href="https://Astrolabe.net/website-hack-protection/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Protect_Your_Site" target="_blank">Protect Your Site</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.268" height="50.2" viewBox="0 0 50.268 50.2">
                                <g id="Group_711" data-name="Group 711" transform="translate(-1327.676 -1939)">
                                  <rect id="Rectangle_556" data-name="Rectangle 556" width="50.254" height="5.017" transform="translate(1327.676 1953.366)" fill="#1b262c"></rect>
                                  <rect id="Rectangle_557" data-name="Rectangle 557" width="50.254" height="5.017" transform="translate(1327.676 1969.277)" fill="#1b262c"></rect>
                                  <path id="Path_1139" data-name="Path 1139" d="M4.08,4.014H46.254V46.188H4.08ZM.067,50.2h50.2V0H.067Z" transform="translate(1327.677 1938.999)" fill="#1b262c"></path>
                                  <rect id="Rectangle_558" data-name="Rectangle 558" width="10.069" height="4.014" transform="translate(1335.623 1947.117)" fill="#028673"></rect>
                                  <rect id="Rectangle_559" data-name="Rectangle 559" width="10.069" height="4.014" transform="translate(1335.623 1962.093)" fill="#028673"></rect>
                                  <rect id="Rectangle_560" data-name="Rectangle 560" width="10.069" height="4.014" transform="translate(1335.623 1977.068)" fill="#028673"></rect>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br>
                                <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                        <p class="text-lg mt-2 mb-10">Get rid of malware and clean up a hacked site</p>
                        <a href="https://Astrolabe.net/website-security-platform/help-now/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Backup_Your_Site" target="_blank">Remove Malware</a>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50">How SiteCheck detects viruses and <br>security threats.</h2>
                </div>

                <div class="app-descriptions mt-8 md:mt-60  bg-white rounded-2xl p-8 md:py-50 md:px-24 grid lg:grid-cols-2 gap-6 md:gap-50">
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                                <defs>
                                  <clippath id="clip-path">
                                    <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"></rect>
                                  </clippath>
                                </defs>
                                <g id="Group_593" data-name="Group 593" transform="translate(0)">
                                  <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.107 2.144)" fill="#008673"></path>
                                  <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" transform="translate(0 0)" fill="#1b262c"></path>
                                  <g id="Group_592" data-name="Group 592" transform="translate(0 0)">
                                    <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                                      <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                    </g>
                                  </g>
                                </g>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Scan Joomla! For Malware &amp; Viruses</h2>
                            <p class="text-xl text-gray-midnight mt-3">Detect malicious code and infected file locations by scanning your external Joomla! site source code.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto"><svg id="Group_589" data-name="Group 589" xmlns="http://www.w3.org/2000/svg" width="50.051" height="50.051" viewBox="0 0 50.051 50.051">
                            <path id="Path_1112" data-name="Path 1112" d="M5,33.319V16.732L16.732,5H33.318L45.046,16.732V33.319L33.318,45.047H16.732ZM14.659,0,0,14.659V35.391L14.659,50.051H35.39l14.66-14.659V14.659L35.39,0Z" fill="#1b262c"></path>
                            <path id="Path_1113" data-name="Path 1113" d="M25.011,32.022l-7.017-7,7.017-7.033,7.017,7.033Z" transform="translate(0.014 0.014)" fill="#008673"></path>
                          </svg>
                          </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Check Joomla! Blacklist Status</h2>
                            <p class="text-xl text-gray-midnight mt-3">See if your Joomla! site is blacklisted by website security authorities such as Google, PhishTank, etc.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_594" data-name="Group 594" xmlns="http://www.w3.org/2000/svg" width="50.667" height="50.602" viewBox="0 0 50.667 50.602">
                                <path id="Path_1122" data-name="Path 1122" d="M25.333,11.318l17.13,34.216H8.2ZM25.333,0,0,50.6H50.667Z" fill="#1b262c"></path>
                                <path id="Path_1123" data-name="Path 1123" d="M25.093,40.606l-7.105-7.088L25.093,26.4,32.2,33.518Z" transform="translate(0.24 0.352)" fill="#008673"></path>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Find Out-of-Date Software &amp; Plugins</h2>
                            <p class="text-xl text-gray-midnight mt-3">Identify if your Joomla! site is running an outdated CMS or vulnerable plugins and extensions.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_590" data-name="Group 590" xmlns="http://www.w3.org/2000/svg" width="48.438" height="48.437" viewBox="0 0 48.438 48.437">
                                <path id="Path_1114" data-name="Path 1114" d="M24.8,36.573,18,29.8,24.8,22.989,31.59,29.8Z" transform="translate(-0.563 -0.719)" fill="#008673"></path>
                                <path id="Path_1115" data-name="Path 1115" d="M4.844,14.531h38.75V43.594H4.844Zm38.75-4.844H0v38.75H48.437V9.687ZM0,4.844H4.844V0H0Zm9.687,0H48.438V0H9.687Z" fill="#1b262c"></path>
                              </svg>
                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Detect Joomla! Security Issues</h2>
                            <p class="text-xl text-gray-midnight mt-3">Check your Joomla! site for security anomalies, configuration issues, and security recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">Why use a Joomla! checker?</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Regularly monitoring your site for malware and indicators of compromise can help you keep tabs on your Joomla! site’s security and focus your perspective to identify security related issues. Quick response to threats help maintain SEO rankings, organic traffic, brand reputation, and protect website visitors from harm.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">How to check if a Joomla! website is safe.</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Scanning a Joomla! site’s source code for malicious links, redirects, iframes, JavaScript, or spam can help you determine if a Joomla! site is not safe to use. Run a web safety check with SiteCheck to scan for any viruses or malware for a specific URL. A quick remote malware scan can help you pinpoint any configuration issues or security anomalies at the client level.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100 mb-50 md:mb-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50 text-left md:text-center">About Astrolabe</h3>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">What is Astrolabe SiteCheck?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">The SiteCheck scanner remotely checks any URL for security threats, malware, defacements, out-of-date CMS, blacklisting, and other important security issues. It visits a Joomla! site like an everyday user would to verify the source code for malicious behavior or security anomalies.</p>
                    <p class="text-lg md:text-xl mt-6 text-left">Since the remote scanner only has access to what’s visible on the browser level, it will not detect anything on the server-side. To scan every file in a website’s directory and detect phishing pages, backdoors, mailers, DoS scripts or any other malware at the server level enable the <a href="https://Astrolabe.net/website-security-platform/" target="_blank" class="underline">Astrolabe Platform.</a></p>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">Is Astrolabe SiteCheck safe?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">SiteCheck helps millions of webmasters every year by providing free remote Joomla! site scanning for security issues. Astrolabe’s SiteCheck monitoring is powered by a highly technical team of security professionals distributed around the world. Our trained security team is skilled at identifying issues and cleaning up hacked Joomla! sites.</p>
                </div>
            </div>

        </section>

        <section class="w-full text-center mt-50 md:mt-100" id="drupal-homepage">
            <div class="container">
                <div class="w-full p-25 md:p-50 bg-white rounded-2xl" id="drupal-scanhome">
                    <h1 class="text-green text-4xl lg:text-40 xl:text-50 leading-none">Free Drupal malware and security checker</h1>
                    <p class="text-lg md:text-xl my-10 font-normal">Enter a URL like example.com and the Astrolabe SiteCheck scanner will check the Drupal site for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code.</p>

                    <div class="text-red medium-text pb-9 clearfix" style="display:none" id="formerror"></div>
                    <noscript>
                        <div class="text-red medium-text pb-9 clearfix">This website requires JavaScript. Please enable JavaScript in your browser.</div>
                    </noscript>
                    <form action="https://sitecheck.Astrolabe.net/" method="get" class="w-full flex flex-col md:flex-row items-stretch" id="drupal-scanform" onsubmit="return onSubmitScanForm(event)">
                        <input placeholder="example.com" type="text" name="scan" id="drupal-websiteurl" class="rounded-none text-xl py-4 w-full px-8 border-2 border-green focus:outline-none" autofocus="">

                        <button class="auto-track bg-green hover:bg-gray-midnight rounded-none text-2xl font-bold px-14 py-4 whitespace-nowrap text-white" data-gatrack="Button_Click, Scan_Website" type="submit">Submit</button>
                    </form>

                </div>
            </div>

            <div class="container mt-5">
                <div class="w-full">
                    <p class="text-base leading-6 text-gray-dark">
                        <strong>Disclaimer:</strong> Astrolabe SiteCheck is a free Drupal site security scanner. Remote scanners have limited access and results are not guaranteed.<br> For a full website scan at the client and server levels, <a href="https://Astrolabe.net/company/contact-us/" target="_blank">contact our team.</a>
                    </p>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl md:text-5xl leading-none">Drupal protection you can depend on.</h2>
                </div>

                <div class="products-row grid lg:grid-cols-3 mt-25 md:mt-60 gap-6 md:gap-50">
                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                                <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"></path>
                                <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"></path>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip right-0">The Astrolabe Platform continuously scans your Drupal site and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                <br><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>
                        <h3 class="text-gray-midnight text-2xl font-bold">Drupal Monitoring</h3>
                        <p class="text-lg mt-2 mb-10">Find and identify malware and issues on your site</p>
                        <a href="https://Astrolabe.net/malware-detection-scanning/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" target="_blank" data-gatrack="Button_Click, Remove_Malware">Detect Malware</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                                <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                                  <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"></path>
                                  <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"></path>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops Drupal site hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Drupal Firewall</h3>
                        <p class="text-lg mt-2 mb-10">Protect and speed up<br> your site</p>
                        <a href="https://Astrolabe.net/website-hack-protection/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Protect_Your_Site" target="_blank">Protect Your Site</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.268" height="50.2" viewBox="0 0 50.268 50.2">
                                <g id="Group_711" data-name="Group 711" transform="translate(-1327.676 -1939)">
                                  <rect id="Rectangle_556" data-name="Rectangle 556" width="50.254" height="5.017" transform="translate(1327.676 1953.366)" fill="#1b262c"></rect>
                                  <rect id="Rectangle_557" data-name="Rectangle 557" width="50.254" height="5.017" transform="translate(1327.676 1969.277)" fill="#1b262c"></rect>
                                  <path id="Path_1139" data-name="Path 1139" d="M4.08,4.014H46.254V46.188H4.08ZM.067,50.2h50.2V0H.067Z" transform="translate(1327.677 1938.999)" fill="#1b262c"></path>
                                  <rect id="Rectangle_558" data-name="Rectangle 558" width="10.069" height="4.014" transform="translate(1335.623 1947.117)" fill="#028673"></rect>
                                  <rect id="Rectangle_559" data-name="Rectangle 559" width="10.069" height="4.014" transform="translate(1335.623 1962.093)" fill="#028673"></rect>
                                  <rect id="Rectangle_560" data-name="Rectangle 560" width="10.069" height="4.014" transform="translate(1335.623 1977.068)" fill="#028673"></rect>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br>
                                <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                        <p class="text-lg mt-2 mb-10">Get rid of malware and clean up a hacked site</p>
                        <a href="https://Astrolabe.net/website-security-platform/help-now/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Backup_Your_Site" target="_blank">Remove Malware</a>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50">How SiteCheck detects viruses and <br>security threats.</h2>
                </div>

                <div class="app-descriptions mt-8 md:mt-60  bg-white rounded-2xl p-8 md:py-50 md:px-24 grid lg:grid-cols-2 gap-6 md:gap-50">
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                                <defs>
                                  <clippath id="clip-path">
                                    <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"></rect>
                                  </clippath>
                                </defs>
                                <g id="Group_593" data-name="Group 593" transform="translate(0)">
                                  <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.107 2.144)" fill="#008673"></path>
                                  <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" transform="translate(0 0)" fill="#1b262c"></path>
                                  <g id="Group_592" data-name="Group 592" transform="translate(0 0)">
                                    <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                                      <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                    </g>
                                  </g>
                                </g>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Scan Drupal For Malware &amp; Viruses</h2>
                            <p class="text-xl text-gray-midnight mt-3">Detect malicious code and infected file locations by scanning your external Drupal site source code.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto"><svg id="Group_589" data-name="Group 589" xmlns="http://www.w3.org/2000/svg" width="50.051" height="50.051" viewBox="0 0 50.051 50.051">
                            <path id="Path_1112" data-name="Path 1112" d="M5,33.319V16.732L16.732,5H33.318L45.046,16.732V33.319L33.318,45.047H16.732ZM14.659,0,0,14.659V35.391L14.659,50.051H35.39l14.66-14.659V14.659L35.39,0Z" fill="#1b262c"></path>
                            <path id="Path_1113" data-name="Path 1113" d="M25.011,32.022l-7.017-7,7.017-7.033,7.017,7.033Z" transform="translate(0.014 0.014)" fill="#008673"></path>
                          </svg>
                          </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Check Drupal Blacklist Status</h2>
                            <p class="text-xl text-gray-midnight mt-3">See if your Drupal site is blacklisted by website security authorities such as Google, PhishTank, etc.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_594" data-name="Group 594" xmlns="http://www.w3.org/2000/svg" width="50.667" height="50.602" viewBox="0 0 50.667 50.602">
                                <path id="Path_1122" data-name="Path 1122" d="M25.333,11.318l17.13,34.216H8.2ZM25.333,0,0,50.6H50.667Z" fill="#1b262c"></path>
                                <path id="Path_1123" data-name="Path 1123" d="M25.093,40.606l-7.105-7.088L25.093,26.4,32.2,33.518Z" transform="translate(0.24 0.352)" fill="#008673"></path>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Find Out-of-Date Software &amp; Plugins</h2>
                            <p class="text-xl text-gray-midnight mt-3">Identify if your Drupal site is running an outdated CMS or vulnerable plugins and extensions.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_590" data-name="Group 590" xmlns="http://www.w3.org/2000/svg" width="48.438" height="48.437" viewBox="0 0 48.438 48.437">
                                <path id="Path_1114" data-name="Path 1114" d="M24.8,36.573,18,29.8,24.8,22.989,31.59,29.8Z" transform="translate(-0.563 -0.719)" fill="#008673"></path>
                                <path id="Path_1115" data-name="Path 1115" d="M4.844,14.531h38.75V43.594H4.844Zm38.75-4.844H0v38.75H48.437V9.687ZM0,4.844H4.844V0H0Zm9.687,0H48.438V0H9.687Z" fill="#1b262c"></path>
                              </svg>
                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Detect Drupal Security Issues</h2>
                            <p class="text-xl text-gray-midnight mt-3">Check your Drupal site for security anomalies, configuration issues, and security recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">Why use a Drupal checker?</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Regularly monitoring your site for malware and indicators of compromise can help you keep tabs on your Drupal site’s security and focus your perspective to identify security related issues. Quick response to threats help maintain SEO rankings, organic traffic, brand reputation, and protect website visitors from harm.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">How to check if a Drupal website is safe.</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Scanning a Drupal site’s source code for malicious links, redirects, iframes, JavaScript, or spam can help you determine if a Drupal site is not safe to use. Run a web safety check with SiteCheck to scan for any viruses or malware for a specific URL. A quick remote malware scan can help you pinpoint any configuration issues or security anomalies at the client level.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100 mb-50 md:mb-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50 text-left md:text-center">About Astrolabe</h3>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">What is Astrolabe SiteCheck?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">The SiteCheck scanner remotely checks any URL for security threats, malware, defacements, out-of-date CMS, blacklisting, and other important security issues. It visits a Drupal site like an everyday user would to verify the source code for malicious behavior or security anomalies.</p>
                    <p class="text-lg md:text-xl mt-6 text-left">Since the remote scanner only has access to what’s visible on the browser level, it will not detect anything on the server-side. To scan every file in a website’s directory and detect phishing pages, backdoors, mailers, DoS scripts or any other malware at the server level enable the <a href="https://Astrolabe.net/website-security-platform/" target="_blank" class="underline">Astrolabe Platform.</a></p>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">Is Astrolabe SiteCheck safe?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">SiteCheck helps millions of webmasters every year by providing free remote Drupal site scanning for security issues. Astrolabe’s SiteCheck monitoring is powered by a highly technical team of security professionals distributed around the world. Our trained security team is skilled at identifying issues and cleaning up hacked Drupal sites.</p>
                </div>
            </div>

        </section>

        <section class="w-full text-center mt-50 md:mt-100" id="magento-homepage">
            <div class="container">
                <div class="w-full p-25 md:p-50 bg-white rounded-2xl" id="magento-scanhome">
                    <h1 class="text-green text-4xl lg:text-40 xl:text-50 leading-none">Free Magento malware and security checker</h1>
                    <p class="text-lg md:text-xl my-10 font-normal">Enter a URL like example.com and the Astrolabe SiteCheck scanner will check the Magento site for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code.</p>

                    <div class="text-red medium-text pb-9 clearfix" style="display:none" id="formerror"></div>
                    <noscript>
                        <div class="text-red medium-text pb-9 clearfix">This website requires JavaScript. Please enable JavaScript in your browser.</div>
                    </noscript>
                    <form action="https://sitecheck.Astrolabe.net/" method="get" class="w-full flex flex-col md:flex-row items-stretch" id="magento-scanform" onsubmit="return onSubmitScanForm(event)">
                        <input placeholder="example.com" type="text" name="scan" id="magento-websiteurl" class="rounded-none text-xl py-4 w-full px-8 border-2 border-green focus:outline-none" autofocus="">

                        <button class="auto-track bg-green hover:bg-gray-midnight rounded-none text-2xl font-bold px-14 py-4 whitespace-nowrap text-white" data-gatrack="Button_Click, Scan_Website" type="submit">Submit</button>
                    </form>

                </div>
            </div>

            <div class="container mt-5">
                <div class="w-full">
                    <p class="text-base leading-6 text-gray-dark">
                        <strong>Disclaimer:</strong> Astrolabe SiteCheck is a free Magento site security scanner. Remote scanners have limited access and results are not guaranteed.<br> For a full website scan at the client and server levels, <a href="https://Astrolabe.net/company/contact-us/" target="_blank">contact our team.</a>
                    </p>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl md:text-5xl leading-none">Magento protection you can depend on.</h2>
                </div>

                <div class="products-row grid lg:grid-cols-3 mt-25 md:mt-60 gap-6 md:gap-50">
                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                                <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"></path>
                                <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"></path>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip right-0">The Astrolabe Platform continuously scans your Magento site and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                <br><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>
                        <h3 class="text-gray-midnight text-2xl font-bold">Magento Monitoring</h3>
                        <p class="text-lg mt-2 mb-10">Find and identify malware and issues on your site</p>
                        <a href="https://Astrolabe.net/malware-detection-scanning/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" target="_blank" data-gatrack="Button_Click, Remove_Malware">Detect Malware</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                                <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                                  <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"></path>
                                  <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"></path>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops Magento site hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Magento Firewall</h3>
                        <p class="text-lg mt-2 mb-10">Protect and speed up<br> your site</p>
                        <a href="https://Astrolabe.net/website-hack-protection/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Protect_Your_Site" target="_blank">Protect Your Site</a>
                    </div>

                    <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center">
                        <span class="icon text-center mx-auto mb-8">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50.268" height="50.2" viewBox="0 0 50.268 50.2">
                                <g id="Group_711" data-name="Group 711" transform="translate(-1327.676 -1939)">
                                  <rect id="Rectangle_556" data-name="Rectangle 556" width="50.254" height="5.017" transform="translate(1327.676 1953.366)" fill="#1b262c"></rect>
                                  <rect id="Rectangle_557" data-name="Rectangle 557" width="50.254" height="5.017" transform="translate(1327.676 1969.277)" fill="#1b262c"></rect>
                                  <path id="Path_1139" data-name="Path 1139" d="M4.08,4.014H46.254V46.188H4.08ZM.067,50.2h50.2V0H.067Z" transform="translate(1327.677 1938.999)" fill="#1b262c"></path>
                                  <rect id="Rectangle_558" data-name="Rectangle 558" width="10.069" height="4.014" transform="translate(1335.623 1947.117)" fill="#028673"></rect>
                                  <rect id="Rectangle_559" data-name="Rectangle 559" width="10.069" height="4.014" transform="translate(1335.623 1962.093)" fill="#028673"></rect>
                                  <rect id="Rectangle_560" data-name="Rectangle 560" width="10.069" height="4.014" transform="translate(1335.623 1977.068)" fill="#028673"></rect>
                                </g>
                              </svg>
                        </span>

                        <div class="tooltip-wrapper top-8 right-8">
                            <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br>
                                <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                            </div><i class="tooltip-icon"></i>
                        </div>

                        <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                        <p class="text-lg mt-2 mb-10">Get rid of malware and clean up a hacked site</p>
                        <a href="https://Astrolabe.net/website-security-platform/help-now/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Backup_Your_Site" target="_blank">Remove Malware</a>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="w-full">
                    <h2 class="text-4xl lg:text-40 xl:text-50">How SiteCheck detects viruses and <br>security threats.</h2>
                </div>

                <div class="app-descriptions mt-8 md:mt-60  bg-white rounded-2xl p-8 md:py-50 md:px-24 grid lg:grid-cols-2 gap-6 md:gap-50">
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                                <defs>
                                  <clippath id="clip-path">
                                    <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"></rect>
                                  </clippath>
                                </defs>
                                <g id="Group_593" data-name="Group 593" transform="translate(0)">
                                  <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.107 2.144)" fill="#008673"></path>
                                  <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" transform="translate(0 0)" fill="#1b262c"></path>
                                  <g id="Group_592" data-name="Group 592" transform="translate(0 0)">
                                    <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                                      <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                      <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"></path>
                                    </g>
                                  </g>
                                </g>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Scan Magento For Malware &amp; Viruses</h2>
                            <p class="text-xl text-gray-midnight mt-3">Detect malicious code and infected file locations by scanning your external Magento site source code.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto"><svg id="Group_589" data-name="Group 589" xmlns="http://www.w3.org/2000/svg" width="50.051" height="50.051" viewBox="0 0 50.051 50.051">
                            <path id="Path_1112" data-name="Path 1112" d="M5,33.319V16.732L16.732,5H33.318L45.046,16.732V33.319L33.318,45.047H16.732ZM14.659,0,0,14.659V35.391L14.659,50.051H35.39l14.66-14.659V14.659L35.39,0Z" fill="#1b262c"></path>
                            <path id="Path_1113" data-name="Path 1113" d="M25.011,32.022l-7.017-7,7.017-7.033,7.017,7.033Z" transform="translate(0.014 0.014)" fill="#008673"></path>
                          </svg>
                          </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Check Magento Blacklist Status</h2>
                            <p class="text-xl text-gray-midnight mt-3">See if your Magento site is blacklisted by website security authorities such as Google, PhishTank, etc.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_594" data-name="Group 594" xmlns="http://www.w3.org/2000/svg" width="50.667" height="50.602" viewBox="0 0 50.667 50.602">
                                <path id="Path_1122" data-name="Path 1122" d="M25.333,11.318l17.13,34.216H8.2ZM25.333,0,0,50.6H50.667Z" fill="#1b262c"></path>
                                <path id="Path_1123" data-name="Path 1123" d="M25.093,40.606l-7.105-7.088L25.093,26.4,32.2,33.518Z" transform="translate(0.24 0.352)" fill="#008673"></path>
                              </svg>

                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Find Out-of-Date Software &amp; Plugins</h2>
                            <p class="text-xl text-gray-midnight mt-3">Identify if your Magento site is running an outdated CMS or vulnerable plugins and extensions.</p>
                        </div>
                    </div>
                    <div class="flex flex-col md:flex-row md:items-center justify-center md:justify-start">
                        <span class="mb-4 md:mb-0 mx-auto sm:mr-auto">
                            <svg id="Group_590" data-name="Group 590" xmlns="http://www.w3.org/2000/svg" width="48.438" height="48.437" viewBox="0 0 48.438 48.437">
                                <path id="Path_1114" data-name="Path 1114" d="M24.8,36.573,18,29.8,24.8,22.989,31.59,29.8Z" transform="translate(-0.563 -0.719)" fill="#008673"></path>
                                <path id="Path_1115" data-name="Path 1115" d="M4.844,14.531h38.75V43.594H4.844Zm38.75-4.844H0v38.75H48.437V9.687ZM0,4.844H4.844V0H0Zm9.687,0H48.438V0H9.687Z" fill="#1b262c"></path>
                              </svg>
                        </span>
                        <div class="flex flex-col text-left md:pl-12">
                            <h2 class="text-green text-xl font-body font-bold">Detect Magento Security Issues</h2>
                            <p class="text-xl text-gray-midnight mt-3">Check your Magento site for security anomalies, configuration issues, and security recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">Why use a Magento checker?</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Regularly monitoring your site for malware and indicators of compromise can help you keep tabs on your Magento site’s security and focus your perspective to identify security related issues. Quick response to threats help maintain SEO rankings, organic traffic, brand reputation, and protect website visitors from harm.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50">How to check if a Magento website is safe.</h3>
                    <p class="text-lg md:text-xl mt-6 md:mt-50 text-left">Scanning a Magento site’s source code for malicious links, redirects, iframes, JavaScript, or spam can help you determine if a Magento site is not safe to use. Run a web safety check with SiteCheck to scan for any viruses or malware for a specific URL. A quick remote malware scan can help you pinpoint any configuration issues or security anomalies at the client level.</p>
                </div>
            </div>
            <div class="container mt-50 md:mt-100 mb-50 md:mb-100">
                <div class="bg-white rounded-2xl p-12 md:py-50 md:px-24 flex flex-col">
                    <h3 class="text-4xl lg:text-40 xl:text-50 text-left md:text-center">About Astrolabe</h3>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">What is Astrolabe SiteCheck?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">The SiteCheck scanner remotely checks any URL for security threats, malware, defacements, out-of-date CMS, blacklisting, and other important security issues. It visits a Magento site like an everyday user would to verify the source code for malicious behavior or security anomalies.</p>
                    <p class="text-lg md:text-xl mt-6 text-left">Since the remote scanner only has access to what’s visible on the browser level, it will not detect anything on the server-side. To scan every file in a website’s directory and detect phishing pages, backdoors, mailers, DoS scripts or any other malware at the server level enable the <a href="https://Astrolabe.net/website-security-platform/" target="_blank" class="underline">Astrolabe Platform.</a></p>
                    <h4 class="text-left text-xl font-bold text-green font-body mt-6 md:mt-50">Is Astrolabe SiteCheck safe?</h4>
                    <p class="text-lg md:text-xl mt-6 text-left">SiteCheck helps millions of webmasters every year by providing free remote Magento site scanning for security issues. Astrolabe’s SiteCheck monitoring is powered by a highly technical team of security professionals distributed around the world. Our trained security team is skilled at identifying issues and cleaning up hacked Magento sites.</p>
                </div>
            </div>

        </section>

        <section id="results">
        </section>
    </div>

    <script id="results-template" type="x-tmpl-mustache">
        <div class="container my-6 md:my-50">
            <nav class="w-full flex items-center justify-start">
                <a href="javascript:void(0)" class="btn-back" onclick="return onBack()">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="26.259" height="26.259" viewBox="0 0 26.259 26.259">
                      <defs>
                        <filter id="Rectangle_550" x="-9" y="-6" width="44.259" height="44.259" filterUnits="userSpaceOnUse">
                          <feOffset dy="3" input="SourceAlpha"/>
                          <feGaussianBlur stdDeviation="3" result="blur"/>
                          <feFlood flood-opacity="0.161"/>
                          <feComposite operator="in" in2="blur"/>
                          <feComposite in="SourceGraphic"/>
                        </filter>
                        <clipPath id="clip-path">
                          <g transform="matrix(1, 0, 0, 1, 0, 0)" filter="url(#Rectangle_550)">
                            <rect id="Rectangle_550-2" data-name="Rectangle 550" width="26.259" height="26.259" fill="none"/>
                          </g>
                        </clipPath>
                      </defs>
                      <g id="Group_668" data-name="Group 668" clip-path="url(#clip-path)">
                        <path id="Path_1131" data-name="Path 1131" d="M13.144.5A12.644,12.644,0,1,1,.5,13.143,12.643,12.643,0,0,1,13.144.5" transform="translate(-0.014 -0.014)" fill="#fff"/>
                        <path id="Path_1132" data-name="Path 1132" d="M13.144.5A12.644,12.644,0,1,1,.5,13.143,12.643,12.643,0,0,1,13.144.5Z" transform="translate(-0.014 -0.014)" fill="none" stroke="#1a272c" stroke-miterlimit="10" stroke-width="1"/>
                        <path id="Path_1133" data-name="Path 1133" d="M20.046,15.137H12.867v4.484L6.594,13.333l6.273-6.289v3.608h7.179Z" transform="translate(-0.191 -0.204)" fill="#1a272c"/>
                      </g>
                    </svg>

                </a>
                <h1 class="text-xl md:text-3xl leading-none ml-4">{{scanInput}}</h1>
            </nav>
        </div>

        <!-- Malware / Clean Banners -->

        <!-- Scan Header -->

        <div class="container">
            <div class="w-full p-6 md:p-50 bg-white rounded-2xl">
                <div class="w-full flex flex-col md:flex-row justify-start">
                    {{#warnings}}{{#security}}
                    <div class="flex items-center">
                        <i class="icon icon-warning-red extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl text-red">Warning: Malware Detected</h2>
                                <p class="m-0 text-gray-midnight">
                                    Infected with malware. Immediate action is required
                                </p>
                        </div>
                    </div>
                    {{/security}}{{^security}}

                    {{#scan_failed.length}}
                    <div class="flex items-center">
                        <i class="icon icon-warning-yellow extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl">Scan failed</h2>
                                <p class="m-0 text-gray-midnight">
                                    {{scan_failed.0.msg}}
                                </p>
                        </div>
                    </div>
                    {{/scan_failed.length}}{{^scan_failed}}

                    {{#site_issue.length}}
                    <div class="flex items-center">
                        <i class="icon icon-warning-yellow extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl">Site Issue</h2>
                                <p class="m-0 text-gray-midnight">
                                    {{site_issue.0.msg}}
                                </p>
                        </div>
                    </div>
                    {{/site_issue.length}}{{^site_issue}}

                    {{#outdated.length}}
                    <div class="flex items-center">
                        <i class="icon icon-warning-yellow extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl">Site is Outdated</h2>
                            <p class="m-0 text-gray-midnight outdated-scan-detail">
                                Our scanner didn't detect any malware
                            </p>
                        </div>
                    </div>
                    {{/outdated.length}}{{/site_issue}}{{/scan_failed}}{{/security}}{{/warnings}}
                    {{^warnings}}

                    <div class="flex items-center">
                        <i class="icon icon-check extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl">No Malware Found</h2>
                                <p class="m-0 text-gray-midnight">
                                    Our scanner didn't detect any malware
                                </p>
                        </div>
                    </div>
                    {{/warnings}}


                    <!-- RIGHT HEADER -->
                    {{#blacklists.length}}
                    <div class="flex items-center hasblacklist mt-3 md:mt-0 md:ml-50">
                        <i class="icon icon-warning-red extra-large flex-shrink-0"></i>
                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl text-red">Site is Blacklisted</h2>
                                <p class="m-0 text-gray-midnight">
                                    {{blacklistedShort}}
                                </p>
                        </div>
                    </div>

                    {{/blacklists.length}}{{^blacklists}}{{^warnings.security}}

                    <div class="flex items-center notblacklisted mt-3 md:mt-0 md:ml-50">

                        <i class="icon icon-check extra-large flex-shrink-0"></i>

                        <div class="ml-4">
                            <h2 class="text-lg md:text-xl">Site is not Blacklisted</h2>
                                <p class="m-0 text-gray-midnight">
                                    9 Blacklists checked
                                </p>
                        </div>

                    </div>

                    {{/warnings.security}}{{/blacklists}}


                    {{#warnings.security}}
                    <div class="md:ml-auto mt-6 md:mt-0">
                        <a class="btn bg-red hover:bg-gray-midnight rounded-full text-base text-white leading-none py-3 px-5 inline-block maincta product-cta auto-track" data-gatrack="Button_Click, Request_Cleanup" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Cleanup</a>
                    </div>
                    {{/warnings.security}}
                    {{^warnings.security}}{{#blacklists.length}}
                    <div class="md:ml-auto mt-6 md:mt-0">
                        <a class="btn bg-red hover:bg-gray-midnight rounded-full text-base text-white leading-none py-3 px-5 inline-block maincta product-cta auto-track" data-gatrack="Button_Click, Request_Cleanup" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Cleanup</a>
                    </div>
                    {{/blacklists.length}}

                    {{^blacklists}}{{#warnings.site_issue.length}}
                    <div class="md:ml-auto mt-6 md:mt-0">
                        <a class="btn bg-yellow hover:bg-gray-midnight rounded-full text-base text-white leading-none py-3 px-5 btn-warning-orange inline-block maincta product-cta auto-track" data-gatrack="Button_Click, Request_Review" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Review</a>
                    </div>
                    {{/warnings.site_issue.length}}

                    {{^warnings.site_issue}}{{#warnings.scan_failed.length}}
                    <div class="md:ml-auto mt-6 md:mt-0">
                        <a class="btn bg-yellow hover:bg-gray-midnight rounded-full text-base text-white leading-none py-3 px-5 btn-warning-orange inline-block maincta product-cta auto-track" data-gatrack="Button_Click, Request_Review" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Review</a>
                    </div>
                    {{/warnings.scan_failed.length}}
                    {{/warnings.site_issue}}{{/blacklists}}{{/warnings.security}}
                </div>

                <!-- Scan Summary -->

                <div class="flex p-8 border my-10 flex flex-col md:flex-row justify-start border-gray-1d rounded-xl">
                    <div class="flex flex-col md:flex-row md:items-center md:pr-8">
                        {{#warnings}}
                        <span class="hidden md:inline-block">
                           <svg id="Group_658" data-name="Group 658" xmlns="http://www.w3.org/2000/svg" width="41.402" height="51.912" viewBox="0 0 41.402 51.912">
                              <path id="Path_1128" data-name="Path 1128" d="M5.188,18.187l17.2-13H36.213V46.723H5.188ZM20.649,0,0,15.6V51.912H41.4V0Z" fill="#1b262c"/>
                              <path id="Path_1129" data-name="Path 1129" d="M27.489,25.278l-7.258,7.276-7.293-7.276L20.231,18Z" transform="translate(0.487 0.678)" fill="#CE3030"/>
                            </svg>
                        </span>
                        {{/warnings}}
                        {{^warnings}}
                        <span class="hidden md:inline-block">
                               <svg id="Group_658" data-name="Group 658" xmlns="http://www.w3.org/2000/svg" width="41.402" height="51.912" viewBox="0 0 41.402 51.912">
                                  <path id="Path_1128" data-name="Path 1128" d="M5.188,18.187l17.2-13H36.213V46.723H5.188ZM20.649,0,0,15.6V51.912H41.4V0Z" fill="#1b262c"/>
                                  <path id="Path_1129" data-name="Path 1129" d="M27.489,25.278l-7.258,7.276-7.293-7.276L20.231,18Z" transform="translate(0.487 0.678)" fill="#008673"/>
                                </svg>
                            </span>
                        {{/warnings}}

                        <div class="md:ml-4">
                            {{#site.redirects_to.length}}<b>Redirects to:</b>{{/site.redirects_to.length}}
                            <p class="overflow-ellipsis width-max-300">{{site.final_url}}{{^site.final_url}}{{site.input}}{{/site.final_url}}</p>
                        </div>
                    </div>

                    <div class="flex flex-col md:pl-8 mt-3 md:mt-0 systemtype md:border-l border-gray-midnight">
                        <p>
                            <b>IP address:</b>
                            <span>{{site.ip.0}}{{^site.ip}}Host not found{{/site.ip}}</span>
                        </p>
                        {{#site}}{{#hosting}}
                        <p>
                            <b>Hosting:</b>
                            <span>{{.}}</span>
                        </p>
                        {{/hosting}}
                        {{^hosting}}{{#cdn}}
                        <p>
                            <b>CDN:</b>
                            <span>{{.}}</span>
                        </p>
                        {{/cdn}}{{^cdn}}
                        <p>
                            <b>Hosting:</b>
                            <span>Unknown</span>
                        </p>
                        {{/cdn}}{{/hosting}}{{/site}}
                        <p>
                            <b>Running on:</b>
                            <span>{{#software.server.0}}{{name}} {{version}}{{/software.server.0}}{{^software.server}}{{site.running_on.0}}{{^site.running_on}}Unknown server{{/site.running_on}}{{/software.server}}{{#software.os.0}}, {{name}} {{version}}{{/software.os.0}}</span>
                        </p>
                    </div>

                    <div class="flex flex-col md:pl-8 mt-3 md:mt-0 systemtype">
                        <p>
                            <b>CMS:</b>
                            <span>{{#software.cms.0}}{{name}} {{version}}{{/software.cms.0}} {{^software.cms}}Unknown{{/software.cms}}</span>
                        </p>
                        <p>
                            <b>Powered by:</b>
                            <span>{{#software.language.0}}{{name}} {{version}}{{/software.language.0}}
                            {{^software.language}}{{site.powered_by.0}}{{^site.powered_by}}Unknown{{/site.powered_by}}{{/software.language}}</span>
                        </p>
                        <p>
                            <a href="#" onclick="return showSiteDetails()" class="underline italic js-show-site-details">More Details</a>
                        </p>
                    </div>

                </div>


                <!-- Security Risk Bar -->

                <div class="rating-bar-wrapper mb-10">
                    <div class="rating-bar">
                        <div class="bar" style="width:{{ratingBarPosition}}%; background-color:{{ratingBarColor}}"></div>
                    </div>
                    <div class="rating-indicators">
                        <span{{&ratingActiveA}}>Minimal{{#ratingActiveA}} Security Risk{{/ratingActiveA}}</span>
                        <span{{&ratingActiveB}}>Low{{#ratingActiveB}} Security Risk{{/ratingActiveB}}</span>
                        <span{{&ratingActiveC}}>Medium{{#ratingActiveC}} Security Risk{{/ratingActiveC}}</span>
                        <span{{&ratingActiveD}}>High{{#ratingActiveD}} Security Risk{{/ratingActiveD}}</span>
                        <span{{&ratingActiveE}}>Critical{{#ratingActiveE}} Security Risk{{/ratingActiveE}}</span>
                    </div>

                    <!-- Malware Detected -->
                    <table class="property-list malware-list pt-6 pb-3 mt-10" id="malware-list">
                    {{#warnings.security_merged}}
                    <tr>
                        <td>
                            <b class="px-2 bg-red rounded font-semibold text-white leading-none py-1 mb-1 inline-block">{{type}}</b>
                            <p><span class="text-gray-midnight">{{location}}</span> <span class="font-normal">(<a href="javascript:void(0)" onclick="return onToggleLog(this)">More Details</a>)</span></p>
                        </td>
                        <td>
                            <b>&nbsp;</b>
                            <p>{{#info_url}}<a href="{{.}}" class="underline" target="_blank">{{/info_url}}{{msg}}{{#signature}}: {{.}}{{/signature}}{{#info_url}}</a>{{/info_url}}</p>
                        </td>
                    </tr>
                    <tr class="log">
                        <td colspan="2">
                            <div class="code-snippet">
                                <div class="code-snippet-padding">
                                    <pre class=" hljs xml">{{details}}</pre>
                                    {{#redirect}}<small>Redirects to {{.}}</small>{{/redirect}}{{#condition}}<small> {{.}}</small>{{/condition}}
                                </div>
                            </div>
                        </td>
                    </tr>
                    {{/warnings.security_merged}}

                    {{#warnings.scan_failed}}
                    <tr>
                        <td>
                            <b class="px-2 bg-yellow rounded font-semibold text-white leading-none py-1 mb-1 inline-block">{{type}}</b>
                            <p><span class="text-gray-midnight">{{location}}</span> <span class="font-normal">{{#details}}(<a href="javascript:void(0)" onclick="return onToggleLog(this)">More Details</a>){{/details}}</span></p>
                        </td>
                        <td>
                            <b>&nbsp;</b>
                            <p>{{#info_url}}<a href="{{.}}" class="underline" target="_blank">{{/info_url}}Unable to scan your site. {{msg}}{{#info_url}}</a>{{/info_url}}</p>
                        </td>
                    </tr>
                    {{#details}}
                    <tr class="log">
                        <td colspan="2">
                            <div class="code-snippet">
                                <div class="code-snippet-padding">
                                    <pre class=" hljs xml">{{details}}{{#redirect}}
                                        Redirects to {{.}}{{/redirect}}{{#condition}}
                                        {{.}}{{/condition}}</pre>
                                </div>
                            </div>
                        </td>
                    </tr>
                    {{/details}}
                    {{^details}}
                    <tr class="log"></tr>
                    {{/details}}
                    {{/warnings.scan_failed}}

                    {{#warnings.site_issue}}
                    <tr>
                        <td>
                            <b class="px-2 bg-yellow rounded font-semibold text-white leading-none py-1 mb-1 inline-block">{{type}}</b>
                            <p><span class="text-gray-midnight">{{location}}</span> <span class="font-normal">{{#details}}(<a href="javascript:void(0)" onclick="return onToggleLog(this)">More Details</a>){{/details}}</span></p>
                        </td>
                        <td>
                            <b>&nbsp;</b>
                            <p>{{#info_url}}<a href="{{.}}" class="underline" target="_blank">{{/info_url}}{{#unableToScan}}Unable to scan the page. {{/unableToScan}}{{msg}}{{#signature}}: {{.}}{{/signature}}{{#info_url}}</a>{{/info_url}}</p>
                        </td>
                    </tr>
                    {{#details}}
                    <tr class="log">
                        <td colspan="2">
                            <div class="code-snippet">
                                <div class="code-snippet-padding">
                                    <pre class=" hljs xml">{{details}}{{#redirect}}
                                    Redirects to {{.}}{{/redirect}}{{#condition}}
                                    {{.}}{{/condition}}</pre>
                                </div>
                            </div>
                        </td>
                    </tr>
                    {{/details}}
                    {{^details}}
                    <tr class="log"></tr>
                    {{/details}}
                    {{/warnings.site_issue}}

                    {{#warnings.outdated}}
                    <tr>
                        <td>
                            <b class="px-2 bg-yellow rounded font-semibold text-white leading-none py-1 mb-1 inline-block">Outdated Software Detected</b>
                            <p class="text-gray-midnight">{{name}} under {{safe_version}}</p>
                        </td>
                        <td>
                            <p>&nbsp;</p>
                            <span><a href="{{upgrade_url}}" class="underline italic" target="_blank">{{upgrade_text}}</a></span>
                        </td>
                    </tr>
                    <tr class="log"></tr>
                    {{/warnings.outdated}}
                    </table>
                </div>

                <!-- MALWARE Security Risk -->

                <div class="">
                    {{#warnings.security}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-red mb-4">Your site is hacked and needs immediate attention. Malicious code was detected on your site by our automated scanner. <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">Sign up</a> to secure your site with a complete scan and guaranteed malware removal.</p>
                    {{/warnings.security}}
                    {{^warnings.security}}{{#blacklists.length}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-red mb-4">Your site is blacklisted and needs immediate attention. Web authorities are blocking traffic because your website is unsafe for visitors. <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">Sign up</a> to secure your site with guaranteed malware and blacklist removal.</p>
                    {{/blacklists.length}}
                    {{^blacklists}}{{#warnings.scan_failed.length}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">Our automated scan was unable to run on your website. Please try again or contact us via chat. If you believe your website has been hacked, <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">sign up</a> for a complete scan and guaranteed malware removal.</p>
                    {{/warnings.scan_failed.length}}
                    {{^warnings.scan_failed}}{{#warnings.site_issue.length}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">Our automated scan found an issue on some pages of your website. If you believe your website has been hacked, <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">sign up</a> for a complete scan and guaranteed malware removal.</p>
                    {{/warnings.site_issue.length}}
                    {{^warnings.site_issue}}{{#warnings.outdated.length}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">Our automated scan detects outdated software on your site. Missing security updates can leave your site vulnerable. If you cannot update your site, <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">sign up</a> for virtual patching via our website firewall.</p>
                    {{/warnings.outdated.length}}
                    {{^warnings.outdated}}
                    <p class="py-4 px-6 rounded-xl shadow box-info-ok mb-4">Our automated scan did not detect malware on your site. If you still believe that your site has been hacked, <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">sign up</a> for a complete scan, manual audit, and guaranteed malware removal.</p>
                    {{#recommendations.security_minor.parked_domain}}
                    <p class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-green mb-4">Scan skipped for a parked domain.</p>
                    {{/recommendations.security_minor.parked_domain}}
                    {{/warnings.outdated}}
                    {{/warnings.site_issue}}{{/warnings.scan_failed}}


                    {{#recommendations.tls_major}}
                    <div class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">
                    <h3 class="mb-2 text-17">TLS Recommendations</h3>

                    {{#http_credit_card}}
                    <p>Credit card input field detected on an unencrypted HTTP page. Please use <a href="https://Astrolabe.net/guides/how-to-install-ssl-certificate#cfmcw" target="_blank">HTTPS protocol</a> to protect sensitive user input:{{#pages}}<br>{{.}}{{/pages}}</p>
                    {{/http_credit_card}}

                    {{#http_password}}
                    <p>Password input field detected on an unencrypted HTTP page. Please use <a href="https://Astrolabe.net/guides/how-to-install-ssl-certificate#cfmcw" target="_blank">HTTPS protocol</a> to protect login forms:{{#pages}}<br>{{.}}{{/pages}}</p>
                    {{/http_password}}

                    {{#no_https}}
                    <p>HTTPS version of this website is not accessible: {{details}}. Please consider <a href="https://Astrolabe.net/guides/how-to-install-ssl-certificate" target="_blank">setting up HTTPS</a> to avoid <a href="https://godaddy.com/web-security/website-not-secure" target="_blank">the "Not Secure" browser warning.</a></p>
                    {{/no_https}}

                    {{#no_redirect_to_https}}
                    <p>No redirect from HTTP to HTTPS found. You should <a href="https://Astrolabe.net/guides/how-to-install-ssl-certificate#fh" target="_blank">redirect your website visitors to the HTTPS version</a> to avoid <a href="https://godaddy.com/web-security/website-not-secure" target="_blank">the "Not Secure" browser warning.</a></p>
                    {{/no_redirect_to_https}}

                    {{#mixed_content}}
                    <p>HTTPS mixed content found. Your HTTPS website <a href="https://docs.Astrolabe.net/website-firewall/troubleshooting/how-to-fix-ssl-mixed-content-warnings/" target="_blank">is referring to an HTTP resource</a>:{{#pages}}<br>{{.}}{{/pages}}</p>
                    {{/mixed_content}}

                    {{#3des_cipher}}
                    <p>Triple-DES cipher is <a href="https://sweet32.info" target="_blank">vulnerable and insecure.</a> Please upgrade <a href="https://wiki.mozilla.org/Security/Server_Side_TLS" target="_blank">your TLS configuration.</a></p>
                    {{/3des_cipher}}

                    {{#tls_10}}
                    <p>TLS 1.0 is <a href="https://blog.Astrolabe.net/2018/06/Astrolabe-enhances-security-by-disabling-tls-version-1-0-and-1-1.html" target="_blank">obsolete.</a> Please upgrade <a href="https://wiki.mozilla.org/Security/Server_Side_TLS" target="_blank">your TLS configuration.</a></p>
                    {{/tls_10}}

                    {{#tls_11}}
                    <p>TLS 1.1 is <a href="https://blog.Astrolabe.net/2018/06/Astrolabe-enhances-security-by-disabling-tls-version-1-0-and-1-1.html" target="_blank">obsolete.</a> Please upgrade <a href="https://wiki.mozilla.org/Security/Server_Side_TLS" target="_blank">your TLS configuration.</a></p>
                    {{/tls_11}}

                    {{#sha1_intermediate}}
                    <p>SHA-1 signature detected on an intermediate certificate. Upgrade to <a href="https://blog.chromium.org/2014/09/gradually-sunsetting-sha-1.html" target="_blank">a newer certificate.</a></p>
                    {{/sha1_intermediate}}

                    </div>
                    {{/recommendations.tls_major}}

                    {{#recommendations.security_major}}
                    <div class="box box-gray box-info-warning box-recommendation">
                    <h3>Protection Recommendations</h3>

                    {{#directory_listing_enabled}}
                    <p>Directory Listing is <a href="{{site.final_url}}wp-includes/css/" target="_blank">enabled on your site.</a> This can lead to information leakage. We recommend disabling Directory Listing, <a href="https://docs.Astrolabe.net/warnings/hardening/disable-directory-listing/" target="_blank">learn how.</a></p>
                    {{/directory_listing_enabled}}

                    {{#git_visible}}
                    <p>Git directory is publicly accessible <a href="{{site.input}}.git/HEAD" target="_blank">on your site.</a> This can lead to information leakage. We recommend blocking access to the .git directory in your webserver configuration file (typically, .htaccess or nginx.conf).</p>
                    {{/git_visible}}

                    {{#trace_method}}
                    <p>HTTP Trace Method is allowed on your site. Allowing <a href="https://docs.Astrolabe.net/warnings/hardening/http-trace-method/" target="_blank">the TRACE method</a> can be misused to attack your site.</p>
                    {{/trace_method}}

                    </div>
                    {{/recommendations.security_major}}

                    {{/blacklists}}{{/warnings.security}}
                </div>
            </div>

        </div>

        <!-- Scan Results -->
        <section class="container mt-25 md:mt-50 mb-25 md:mb-50">

            <div class="w-full grid md:grid-cols-2 gap-10">

                <div class="">
                    <div class="bg-white relative rounded-lg p-8 md:py-12 md:px-16 flex flex-col justify-start">
                        <h2 class="text-3xl">Website Malware &amp; Security</h2>

                        <ul class="list-none mt-4">
                        {{#warnings.scan_failed.length}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-warning-yellow mr-2"></i><span>Scan failed <span class="text-yellow">(Medium Risk)</span></span></li>
                        {{/warnings.scan_failed.length}}

                        {{^warnings.scan_failed}}
                        {{^warnings.security}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-check mr-2"></i><span>No malware detected by scan <span class="text-gray-midnight">(Low Risk)</span></span></li>
                        {{/warnings.security}}
                        {{#warnings.security}}
                        <li class="flex items-center justify-start text-red py-1"><i class="icon icon-warning-red mr-2"></i><span>Malware detected by scan <span class="text-red">(Critical Risk)</span></span></li>
                        {{/warnings.security}}

                        {{^warnings.security.spam}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-check mr-2"></i><span>No injected spam detected <span class="text-gray-midnight">(Low Risk)</span></span></li>
                        {{/warnings.security.spam}}
                        {{#warnings.security.spam.length}}
                        <li class="flex items-center justify-start text-red py-1"><i class="icon icon-warning-red mr-2"></i><span>Injected spam detected <span class="text-red">(Critical Risk)</span></span></li>
                        {{/warnings.security.spam.length}}

                        {{^warnings.security.defaced}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-check mr-2"></i><span>No defacements detected <span class="text-gray-midnight">(Low Risk)</span></span></li>
                        {{/warnings.security.defaced}}
                        {{#warnings.security.defaced.length}}
                        <li class="flex items-center justify-start text-red py-1"><i class="icon icon-warning-red mr-2"></i><span>Defacements detected <span class="text-red">(Critical Risk)</span></span></li>
                        {{/warnings.security.defaced.length}}

                        {{^warnings.site_issue}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-check mr-2"></i><span>No internal server errors detected <span class="text-gray-midnight">(Low Risk)</span></span></li>
                        {{/warnings.site_issue}}
                        {{#warnings.site_issue.length}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-warning-yellow mr-2"></i><span>Site issues detected <span class="text-yellow">(Medium Risk)</span></span></li>
                        {{/warnings.site_issue.length}}

                        {{^warnings.outdated}}
                        {{#software.cms.0.version}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-check mr-2"></i><span>Site is up to date <span class="text-gray-midnight">(Low Risk)</span>: using {{software.cms.0.name}} {{software.cms.0.version}}</span></li>
                        {{/software.cms.0.version}}
                        {{/warnings.outdated}}
                        {{#warnings.outdated.length}}
                        <li class="flex items-center justify-start py-1"><i class="icon icon-warning-yellow mr-2"></i><span>Site is outdated  <span class="text-yellow">(High Risk)</span></span></li>
                        {{/warnings.outdated.length}}
                        {{/warnings.scan_failed}}

                        </ul>


                        {{#warnings.security}}
                        <div class="pt-6">
                            <a target="_blank" class="btn bg-yellow hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 product-cta auto-track" data-gatrack="Button_Click, Request_Cleanup" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Cleanup</a>
                        </div>
                        {{/warnings.security}}
                        {{^warnings.security}}{{#blacklists.length}}
                        <div class="pt-6">
                            <a target="_blank" class="btn bg-yellow hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 product-cta auto-track" data-gatrack="Button_Click, Request_Cleanup" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Cleanup</a>
                        </div>
                        {{/blacklists.length}}

                        {{^blacklists}}{{#warnings.site_issue.length}}
                        <div class="pt-6">
                            <a target="_blank" class="btn bg-yellow hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 product-cta-orange auto-track" data-gatrack="Button_Click, Request_Review" href="https://Astrolabe.net/website-security-platform/signup/" data-name="malware removal" data-category="website security">Request Review</a>
                        </div>
                        {{/warnings.site_issue.length}}{{/blacklists}}{{/warnings.security}}
                    </div>
                    <div class="w-full products mt-10">

                        <div class="w-full grid md:grid-cols-2 gap-10">

                            <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center text-center">
                                <span class="icon">

                                {{#noAstrolabeWaf}}
                                <i class="icon icon-warning-yellow extra-large"></i>
                                {{/noAstrolabeWaf}}{{^noAstrolabeWaf}}
                                <i class="icon icon-check extra-large"></i>
                                {{/noAstrolabeWaf}}

                                </span>

                                <div class="tooltip-wrapper top-8 right-8"><div class="tooltip">The Astrolabe Platform continuously scans your website and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                                       <br/ ><a target="_blank"  href="https://Astrolabe.net/malware-detection-scanning/" class="product-cta color-white underline" data-name="malware scanning and detection" data-category="website security"><b>Learn More</b></a>
                                </div><i class='tooltip-icon'></i></div>

                                <p class=" font-bold mt-3">Website Monitoring</p>


                                {{#noAstrolabeWaf}}
                                <p class="">Not detected</p>
                                <div class="mt-6">
                                    <a target="_blank"  href="https://Astrolabe.net/malware-detection-scanning/" class="product-cta btn bg-yellow hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 inline-block auto-track" data-gatrack="Button_Click, Learn_More" data-name="malware scanning and detection" data-category="website security">Learn More</a>
                                </div>
                                {{/noAstrolabeWaf}}{{^noAstrolabeWaf}}
                                <p class="detected">Detected</p>
                                <div class="mt-6">
                                    <a target="_blank"  href="https://Astrolabe.net/malware-detection-scanning/" class="product-cta btn bg-green hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 inline-block auto-track" data-gatrack="Button_Click, Learn_More" data-name="malware scanning and detection" data-category="website security">Learn More</a>
                                </div>
                                {{/noAstrolabeWaf}}

                            </div>
                            <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center text-center">
                                <span class="icon">

                                {{#recommendations.security_minor.needs_waf}}
                                    <i class="icon icon-warning-yellow extra-large"></i>
                                {{/recommendations.security_minor.needs_waf}}{{^recommendations.security_minor.needs_waf}}
                                    <i class="icon icon-check extra-large"></i>
                                {{/recommendations.security_minor.needs_waf}}

                                </span>

                                <div class="tooltip-wrapper top-8 right-8"><div class="tooltip">A cloud based WAF stops website hacks and DDoS attacks. Constant research improves how evolving threats are detected and mitigated.
                                    <br /> <a target="_blank"  href="https://Astrolabe.net/website-hack-protection/" class="product-cta color-white underline" data-name="stop website attacks and hacks" data-category="website firewall"><b>Learn More</b></a>
                                </div><i class='tooltip-icon'></i></div>

                                <p class=" font-bold mt-3">Website Firewall</p>

                                {{#recommendations.security_minor.needs_waf}}
                                <p class="">Not Detected</p>
                                <div class="mt-6">
                                    <a target="_blank"  href="https://Astrolabe.net/website-hack-protection/" class="product-cta btn bg-yellow hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-3 inline-block auto-track" data-gatrack="Button_Click, Explore_Astrolabe_Firewall" data-name="stop website attacks and hacks" data-category="website firewall">Explore Astrolabe Firewall</a>
                                </div>

                                {{/recommendations.security_minor.needs_waf}}{{^recommendations.security_minor.needs_waf}}
                                <p class="padding-bottom-25 detected">Firewall Detected</p>
                                <div class="mt-6">
                                    <a target="_blank"  href="https://Astrolabe.net/website-hack-protection/" class="product-cta btn bg-green hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-3 inline-block auto-track" data-gatrack="Button_Click, Explore_Astrolabe_Firewall" data-name="stop website attacks and hacks" data-category="website firewall">Explore Astrolabe Firewall</a>
                                </div>
                                {{/recommendations.security_minor.needs_waf}}

                            </div>
                        </div>
                    </div>
                </div>

                <!-- blacklist -->
                <div class="bg-white relative rounded-lg p-8  md:py-50 md:px-16 flex flex-col justify-start">
                    <h2 class="text-3xl">Website Blacklist Status</h2>
                    <div class="tooltip-wrapper top-8 right-8"><div class="tooltip">Having your website blacklisted means Google (or other authorities) are warning visitors that your site is dangerous.
                    <br /><a class="color-white underline" href="https://Astrolabe.net/malware-detection-scanning/" target="_blank"><b>Learn More</b></a>
                    </div><i class='tooltip-icon'></i></div>

                    <ul class="list-none mt-4">
                        {{#blacklists}}
                        <li class="text-red d-flex items-center py-1"><i class="icon icon-warning-red mr-2"></i><span><a href="{{info_url}}" class="text-red" target="_blank" rel="nofollow">Domain blacklisted by {{vendor}}: {{location}}</a></span></li>
                        {{/blacklists}}
                        {{^blacklistedByGoogleSafeBrowsing}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="http://safebrowsing.clients.google.com/safebrowsing/diagnostic?site={{site.domain}}" target="_blank" rel="nofollow">Domain clean by Google Safe Browsing</a></span></li>
                        {{/blacklistedByGoogleSafeBrowsing}}

                        {{^blacklistedByMcAfee}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="http://www.siteadvisor.com/sitereport.html?url={{site.domain}}" target="_blank" rel="nofollow">Domain clean by McAfee</a></span></li>
                        {{/blacklistedByMcAfee}}

                        {{^blacklistedByAstrolabeLabs}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="https://labs.Astrolabe.net/?blacklist={{site.domain}}" target="_blank" rel="nofollow">Domain clean by Astrolabe Labs</a></span></li>
                        {{/blacklistedByAstrolabeLabs}}

                        {{^blacklistedByESET}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="https://labs.Astrolabe.net/?eset" target="_blank" rel="nofollow">Domain clean by ESET</a></span></li>
                        {{/blacklistedByESET}}

                        {{^blacklistedByPhishTank}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="https://www.phishtank.com" target="_blank" rel="nofollow">Domain clean by PhishTank</a></span></li>
                        {{/blacklistedByPhishTank}}

                        {{^blacklistedByYandex}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="https://www.yandex.com/infected?url={{site.domain}}" target="_blank" rel="nofollow">Domain clean by Yandex</a></span></li>
                        {{/blacklistedByYandex}}

                        {{^blacklistedByOpera}}
                        <li class="py-1 d-flex items-center"><i class="icon icon-check mr-2"></i><span><a href="https://www.opera.com" target="_blank" rel="nofollow">Domain clean by Opera</a></span></li>
                        {{/blacklistedByOpera}}
                    </ul>

                    {{^blacklists}}
                    <p class="mt-4">Your site does not appear to be blacklisted. If you still see security warnings on your site, <a href="https://Astrolabe.net/website-security-platform/signup" target="_blank">sign up</a> for a more complete scan, manual audit, and guaranteed blacklist removal.</p>
                    {{/blacklists}}

                    {{#blacklists.length}}
                    <div class="mt-4">
                        <a target="_blank" class="btn bg-red hover:bg-gray-midnight rounded-full text-sm text-white leading-none py-2 px-4 inline-block product-cta auto-track" data-gatrack="Button_Click, Request_Blacklist_Removal" href="https://Astrolabe.net/website-security-platform/signup/" data-name="blacklist removal" data-category="website security">Request Blacklist Removal</a>
                    </div>
                    {{/blacklists.length}}
                </div>

            </div>

        </section>

        {{^warnings.security}}{{^blacklists}}
        <section class="container mt-25 md:mt-50 mb-25 md:mb-50">
            <div class="bg-white relative rounded-lg p-8 md:py-50 md:px-16 flex flex-col justify-start">
                <h2 class="text-3xl mb-8">Hardening Improvements</h2>

                {{#recommendations.tls_minor}}
                 <div class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">
                <h3 class="mb-3 text-17">TLS</h3>

                {{#weak_cipher_suite}}
                <p>This TLS connection uses obsolete cryptography. Please prioritize <a href="https://wiki.mozilla.org/Security/Server_Side_TLS" target="_blank">modern cipher suites</a> such as ECDHE with AES-GCM.</p>
                {{/weak_cipher_suite}}

                {{#cert_expires_soon}}
                <p>Your TLS certificate will expire soon: {{tls.cert_expires}}. Please consider <a href="https://godaddy.com/web-security/ssl-certificate" target="_blank">obtaining a new certificate</a> for your website.</p>
                {{/cert_expires_soon}}

                {{#mixed_content}}
                <p>HTTPS mixed content found. Your HTTPS website <a href="https://docs.Astrolabe.net/website-firewall/troubleshooting/how-to-fix-ssl-mixed-content-warnings/" target="_blank">is referring to an HTTP resource</a>:{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/mixed_content}}

                </div>
                {{/recommendations.tls_minor}}

                {{#recommendations.security_minor}}
                <div class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">
                <h3 class="mb-3 text-17">Protection</h3>

                {{#needs_waf}}
                <p>No website application firewall detected. Please install a cloud-based WAF to <a href="https://Astrolabe.net/website-hack-protection/" target="_blank">prevent website hacks and DDoS attacks.</a></p>
                {{/needs_waf}}

                {{#spf}}
                <p>Consider creating an SPF record <a href="http://www.openspf.org/Introduction" target="_blank">to prevent spammers from abusing your email address.</a></p>
                {{/spf}}

                {{#spf_no_mx}}
                <p>Consider creating an SPF record <a href="http://www.openspf.org/Introduction" target="_blank">to prevent spammers from abusing your email address.</a> If you don't send any emails from this domain, please use <code>v=spf1 -all</code></p>
                {{/spf_no_mx}}

                {{#spf_more_than_one}}
                <p>More than one <a href="http://www.openspf.org/" target="_blank">SPF record</a> detected, so spam protection may not work correctly. Please review your DNS records and merge <a href="https://tools.ietf.org/html/rfc7208#section-3.2" target="_blank">multiple SPF records</a> into one.</p>
                {{/spf_more_than_one}}

                {{#spf_syntax}}
                <p><a href="http://www.openspf.org/SPF_Record_Syntax" target="_blank">SPF syntax error</a> detected. <a href="http://www.openspf.org/" target="_blank">Spam protection</a> may not work correctly. Please review your DNS records to correct the error: <code>{{details}}</code>.</p>
                {{/spf_syntax}}

                {{#spf_lookup_limit}}
                <p><a href="https://tools.ietf.org/html/rfc7208#section-4.6.4" target="_blank">DNS lookup limit</a> has been reached for your <a href="http://www.openspf.org/" target="_blank">SPF record</a>, so spam protection may not work correctly. Please review your DNS records to correct the error: <code>{{details}}</code>.</p>
                {{/spf_lookup_limit}}

                {{#spf_after_all}}
                <p><a href="https://tools.ietf.org/html/rfc7208#section-5.1" target="_blank">Mechanisms after 'all'</a> will be ignored in your <a href="http://www.openspf.org/" target="_blank">SPF record</a>. Please review your DNS records to correct the problem: <code>{{details}}</code>.</p>
                {{/spf_after_all}}

                {{#spf_ptr}}
                <p><a href="https://tools.ietf.org/html/rfc7208#section-5.5" target="_blank">Obsolete PTR mechanism</a> found in your <a href="http://www.openspf.org/" target="_blank">SPF record</a>. Please review your DNS records to correct the problem: <code>{{details}}</code>.</p>
                {{/spf_ptr}}

                {{#os_commerce_admin_panel}}
                <p>osCommerce admin panel is not secured. <a href="{{site.final_url}}admin/" target="_blank">Test it.</a></p>
                {{/os_commerce_admin_panel}}

                {{#php_display_errors}}
                <p>PHP's <a href="https://secure.php.net/manual/en/errorfunc.configuration.php#ini.display-errors" target="_blank">display_errors</a> is enabled. This setting should be off in the production environment. You can use <code>log_errors</code> instead.</p>
                {{/php_display_errors}}

                {{#invalid_gzip}}
                <p>Invalid gzip format. Please check your compression settings.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/invalid_gzip}}

                {{#local_file}}
                <p>Local file link. Please review these links; they should point to web pages, not to local files:{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/local_file}}

                </div>
                {{/recommendations.security_minor}}

                {{#recommendations.headers_minor}}
                <div class="py-4 px-6 rounded-xl shadow has-l-highlight before:bg-yellow mb-4">
                <h3 class="mb-3 text-17">Security Headers</h3>

                {{#x_frame_options}}
                <p>Missing security header for <a href="https://docs.Astrolabe.net/warnings/hardening/security-headers-x-frame-options/" target="_blank">ClickJacking Protection</a>. Alternatively, you can use <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/frame-ancestors" target="_blank">Content-Security-Policy: frame-ancestors 'none'.</a>{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/x_frame_options}}

                {{#x_content_type_options}}
                <p>Missing security header <a href="https://docs.Astrolabe.net/warnings/hardening/security-headers-x-content-type-nosniff/" target="_blank">to prevent Content Type sniffing</a>.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/x_content_type_options}}

                {{#strict_transport_security}}
                <p>Missing <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security" target="_blank">Strict-Transport-Security security header</a>.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/strict_transport_security}}

                {{#csp}}
                <p>Missing <a href="https://blog.Astrolabe.net/2018/04/content-security-policy.html" target="_blank">Content-Security-Policy directive.</a> We recommend to add the following CSP directives (you can use default-src if all values are the same): {{details}}{{#pages.length}}. Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp}}

                {{#csp_syntax}}
                <p>Syntax error found in <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy" target="_blank">the Content-Security-Policy header:</a> {{details}}{{#pages.length}}. Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp_syntax}}

                {{#csp_duplicate}}
                <p>Duplicate directive found in <a href="https://blog.Astrolabe.net/2018/04/content-security-policy.html" target="_blank">the Content-Security-Policy header:</a> {{details}}{{#pages.length}}. Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp_duplicate}}

                {{#csp_unknown_directive}}
                <p>Unknown directive found in <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy" target="_blank">the Content-Security-Policy header:</a> {{details}}{{#pages.length}}. Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp_unknown_directive}}

                {{#csp_unsafe_inline}}
                <p>The 'unsafe-inline' keyword in <a href="https://blog.Astrolabe.net/2018/04/content-security-policy.html" target="_blank">Content-Security-Policy</a> is not recommended. Consider using <a href="https://w3c.github.io/webappsec-csp/#unsafe-hashes-usage" target="_black">unsafe-hashes</a> or <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/script-src#Unsafe_inline_script" target="_black">nonces</a> instead.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp_unsafe_inline}}

                {{#csp_unsafe_eval}}
                <p>The 'unsafe-eval' keyword in <a href="https://blog.Astrolabe.net/2018/04/content-security-policy.html" target="_blank">Content-Security-Policy</a> is not recommended. Please consider <a href="https://developers.google.com/web/fundamentals/security/csp/#eval_too" target="_blank">fixing the JavaScript code.</a>{{#pages.length}}. Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/csp_unsafe_eval}}

                {{#server_banners}}
                <p>Default server banners displayed. Your site is displaying <a href="https://docs.Astrolabe.net/warnings/hardening/disable-server-banners/" target="_blank">your web server default banners</a>.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/server_banners}}

                {{#leaked_php_version}}
                <p>Leaked PHP version. Your site is displaying your PHP version in the HTTP headers. Please set <a href="https://secure.php.net/manual/en/ini.core.php" target="_blank">expose_php = Off.</a>{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/leaked_php_version}}

                {{#leaked_asp_version}}
                <p>Leaked ASP version. Your site is displaying your ASP version in the HTTP headers. Please set <a href="https://msdn.microsoft.com/en-us/library/e1f13641(v=vs.85).aspx" target="_blank">enableVersionHeader = False.</a>{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/leaked_asp_version}}

                {{#leaked_jsp_version}}
                <p>Leaked JSP version. Your site is displaying your JSP version in the HTTP headers. Please remove this header in your webserver configuration.{{#pages.length}} Affected pages:{{/pages.length}}{{#pages}}<br>{{.}}{{/pages}}</p>
                {{/leaked_jsp_version}}

                </div>
                {{/recommendations.headers_minor}}


                {{^recommendations}}{{^warnings}}
                <p class="box box-gray box-info-ok">No security recommendations detected. Everything looks good.</p>
                {{/warnings}}{{#warnings}}
                <p class="box box-gray box-info-ok">No additional security recommendations.</p>
				{{/warnings}}{{/recommendations}}
            </div>
        </section>
        {{/blacklists}}{{/warnings.security}}

        <section class="container mt-50 md:mt-100 mb-50 md:mb-100">
            <div class="w-full text-center">
                <h2 class="text-4xl md:text-5xl">Hacked? Get help now.</h2>
            </div>

            <div class="products-row grid lg:grid-cols-3 mt-50 gap-6 md:gap-50">
                <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center text-center">
                    <span class="icon text-center mx-auto mb-8">
                        <svg id="Group_576" data-name="Group 576" xmlns="http://www.w3.org/2000/svg" width="49.874" height="49.874" viewBox="0 0 49.874 49.874">
                            <path id="Path_1105" data-name="Path 1105" d="M4.992,32.074V4.992H44.881V32.071L24.915,44.051ZM0,0V34.9L24.913,49.874,49.874,34.9V0Z" fill="#1b262c"/>
                            <path id="Path_1106" data-name="Path 1106" d="M24.989,28.953l-7-6.984,7-7.017,7,7.017Z" transform="translate(-0.028 -0.023)" fill="#008673"/>
                          </svg>
                    </span>

                    <div class="tooltip-wrapper top-8 right-8">
                        <div class="tooltip right-0">The Astrolabe Platform continuously scans your website and checks for hacks, security incidents, and downtime. We offer unlimited malware removal with no hidden fees.
                            <br /><a target="_blank" href="https://Astrolabe.net/malware-detection-scanning/" class="color-white underline"><b>Learn More</b></a>
                        </div><i class='tooltip-icon'></i>
                    </div>
                    <h3 class="text-gray-midnight text-2xl font-bold">Website Monitoring</h3>
                    <p class="text-lg mt-2 mb-10">Find and identify malware
and issues on your site</p>
                    <div class="text-center">
                        <a href="https://Astrolabe.net/malware-detection-scanning/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" target="_blank" data-gatrack="Button_Click, Remove_Malware">Detect Malware</a>
                    </div>
                </div>

                <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center text-center">
                    <span class="icon text-center mx-auto mb-8">
                        <svg xmlns="http://www.w3.org/2000/svg" width="50.022" height="50.023" viewBox="0 0 50.022 50.023">
                            <g id="Group_611" data-name="Group 611" transform="translate(0 0)">
                              <path id="Path_1107" data-name="Path 1107" d="M26.869,24.649l10.8-4.319L25.011,40.58,12.355,20.33l10.8,4.319,1.858.743ZM25.011,20,0,10,25.011,50.018,50.022,10Z" transform="translate(0 0.004)" fill="#1a272c"/>
                              <path id="Path_1108" data-name="Path 1108" d="M25,0,17.988,7.032l7.015,7,7.015-7Z" transform="translate(0.008)" fill="#008673"/>
                            </g>
                          </svg>
                    </span>

                    <div class="tooltip-wrapper top-8 right-8">
                        <div class="tooltip">The Astrolabe Firewall is a cloud-based WAF that stops website hacks and DDoS attacks. Our constant research improves how we detect and mitigate evolving threats.<br /> <a target="_blank" href="https://Astrolabe.net/website-hack-protection/" class="color-white underline"><b>Learn More</b></a>
                        </div><i class='tooltip-icon'></i>
                    </div>

                    <h3 class="text-gray-midnight text-2xl font-bold">Website Firewall</h3>
                    <p class="text-lg mt-2 mb-10">Protect and speed up</br> your site</p>
                    <div class="text-center">
                        <a href="https://Astrolabe.net/website-hack-protection/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Protect_Your_Site" target="_blank">Protect Your Site</a>
                    </div>
                </div>

                <div class="bg-white relative rounded-lg py-6 lg:py-6 xl:py-12 px-6 lg:px-8 xl:px-16 flex flex-col justify-center text-center">
                    <span class="icon text-center mx-auto mb-8">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="55.859" height="55.866" viewBox="0 0 55.859 55.866">
                            <defs>
                            <clipPath id="clip-path">
                              <rect id="Rectangle_523" data-name="Rectangle 523" width="55.859" height="55.866" fill="none"/>
                            </clipPath>
                          </defs>
                          <path id="Path_1116" data-name="Path 1116" d="M25.822,33.963l-7.834-7.815L25.822,18.3l7.834,7.852Z" transform="translate(2.108 2.144)" fill="#008673"/>
                          <path id="Path_1117" data-name="Path 1117" d="M8.126,29.958l5.833-5.652,4.611-4.469-3.8-2.962,13.158-9.89,13.4,10.066-3.679,3.12,4.41,4.287,5.673,5.516L27.931,48.261ZM27.929,0,5.584,16.793l4.489,3.5L0,30.055l27.929,25.81L55.859,30.078l-9.9-9.623,4.326-3.668Z" fill="#1b262c"/>
                          <g id="Group_592" data-name="Group 592">
                            <g id="Group_591" data-name="Group 591" clip-path="url(#clip-path)">
                              <path id="Path_1118" data-name="Path 1118" d="M13.963,34.674,6.386,42.019l8.267,7.639" transform="translate(0.748 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"/>
                              <path id="Path_1119" data-name="Path 1119" d="M36.936,34.674l7.578,7.344-8.267,7.639" transform="translate(4.247 4.063)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"/>
                              <path id="Path_1120" data-name="Path 1120" d="M14.276,11.151,9.6,6.47l4.681-4.682" transform="translate(1.124 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"/>
                              <path id="Path_1121" data-name="Path 1121" d="M36.247,11.151,40.928,6.47,36.247,1.788" transform="translate(4.247 0.21)" fill="none" stroke="#1b262c" stroke-miterlimit="10" stroke-width="5"/>
                            </g>
                          </g>
                        </svg>
                    </span>

                    <div class="tooltip-wrapper top-8 right-8">
                        <div class="tooltip">Scan your website for malware, hacks, and blocklist status. You can rely on our state-of-the-art website malware scanner and remediation team to clean up your site.<br />
                            <a target="_blank" href="https://Astrolabe.net/website-security-platform/help-now/" class="color-white underline"><b>Learn More</b></a>
                        </div><i class='tooltip-icon'></i>
                    </div>

                    <h3 class="text-gray-midnight text-2xl font-bold">Malware Removal</h3>
                    <p class="text-lg mt-2 mb-10">Get rid of malware and
clean up a hacked site</p>
                    <div class="text-center">
                        <a href="https://Astrolabe.net/website-security-platform/help-now/" class="btn auto-track bg-green hover:bg-gray-midnight rounded-full text-base xl:text-xl text-white leading-none py-3 px-5" data-gatrack="Button_Click, Backup_Your_Site" target="_blank">Remove Malware</a>
                    </div>
                </div>
            </div>
        </section>

        <section class="container mt-50 md:mt-100 mb-50 md:mb-100">
            <div class="w-full text-center">
                <p class="text-center italic" id="cache-box">{{cacheTime}} Force a <a href="" class="underline" onclick="return onRescan()"><b>Re-scan</b></a> to clear the
                    cache.
                </p>
                <h3 class="text-4xl lg:text-40 xl:text-50 my-50 md:mt-100 text-center">Check another URL.</h3>
            </div>
            <div class="w-full p-6 md:p-10 bg-white rounded-2xl footer-scan-form">
                <input type="hidden" id="inputWebsite" value="{{site.input}}" />

                <!-- Scan Site Form -->
                <div class="box" id="scananother">
                </div>
                <!-- /search form -->
            </div>
        </section>

        <div class="dialog-window" id="site-details">

        <div class="dialog-window-content w-full bg-white rounded-2xl relative p-8 md:p-16 m-auto mt-12 md:mt-24 shadow-md max-w-3xl flex flex-col">
            <a class="px-2 py-1 text-xs bg-gray-midnight hover:bg-green cursor-pointer text-white rounded-full ml-auto absolute right-4 top-4 md:right-6 md:top-6 js-cancel" onclick="return hideSiteDetails()">Close</a>

            <h2 class="text-2xl">Site Details</h2>

            <hr class="my-4" />

            <div class="mb-4">
                <section class="mb-2"><h4 class="text-xl">System info</h4></section>
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">IP addresses</strong></div><div class="width-65 push-left">{{ips}}{{^ips}}Host not found{{/ips}}</div></div>

                {{#site.hosting}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Hosting</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/site.hosting}}

                {{#site.cdn}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">CDN</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/site.cdn}}

                {{#software.server}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Server</strong></div><div class="width-65 push-left">{{name}} {{version}}</div></div>
                {{/software.server}}

                {{#software.proxy}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Proxy</strong></div><div class="width-65 push-left">{{name}} {{version}}</div></div>
                {{/software.proxy}}

                {{#site.cached_from}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Cached from</strong></div><div class="width-65 push-left">{{name}} {{version}}</div></div>
                {{/site.cached_from}}

                {{#software.os}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">OS</strong></div><div class="width-65 push-left">{{name}} {{version}}</div></div>
                {{/software.os}}

                {{#software.language}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Language</strong></div><div class="width-65 push-left">{{name}} {{version}}</div></div>
                {{/software.language}}
				
                {{#tls.cert_issuer}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">TLS Certificate</strong></div><div class="width-65 push-left">Issued by {{.}}</div></div>
                {{/tls.cert_issuer}}

                {{#site.redirects_to.length}}
                <section class="mb-2"><h4 class="text-xl mt-4">Redirects</h4></section>
                {{/site.redirects_to.length}}

                {{#site.redirects_to}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Redirects to</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/site.redirects_to}}

                {{#software.cms}}
                <section class="mb-2"><h4 class="mb-3 text-xl">Web Application Info</h4></section>
                
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Application</strong></div><div class="width-65 push-left">{{#info_url}}<a href="{{.}}" target="_blank">{{/info_url}}{{name}}{{#info_url}}</a>{{/info_url}}</div></div>
                
                {{#version}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Version</strong></div><div class="width-65 push-left">{{.}}{{#based_on}} based on {{.}}{{/based_on}}</div></div>
                {{/version}}

                {{#theme}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Theme</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/theme}}

                {{#directory}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Directory</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/directory}}

                {{#internal_path}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">Internal path</strong></div><div class="width-65 push-left">{{.}}</div></div>
                {{/internal_path}}
                {{/software.cms}}

                {{#software.plugin.length}}
                <section class="mb-2"><h4 class="text-xl mt-4">Plugins</h4></section>
                {{/software.plugin.length}}

                {{#software.plugin}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">{{name}}</strong></div><div class="width-65 push-left">{{version}}</div></div>
                {{/software.plugin}}

                {{#software.ad_script.length}}
                <section class="mb-2"><h4 class="text-xl mt-4">Ads/analytics</h4></section>
                {{/software.ad_script.length}}

                {{#software.ad_script}}
                <div class="flex py-2"><div class="ml-0 pr-3"><strong class="rounded bg-gray-light px-2 text-gray-midnight text-base">{{name}}</strong></div><div class="width-65 push-left">{{details}}</div></div>
                {{/software.ad_script}}
            </div>
            
            <hr />

            {{#links}}
            <div class="expandible cursor-pointer mt-4" onclick="return onToggleExpandible(this)">
                <a>Links found</a>

                <div class="expandible-content">
                    {{#urls}}
                    <p>{{.}}</p>
                    {{/urls}}
                    {{^urls}}
                    <p>No links found.</p>
                    {{/urls}}
                </div>
            </div>

            <div class="expandible cursor-pointer" onclick="return onToggleExpandible(this)">
                <a>Javascripts included</a>

                <div class="expandible-content">
                    {{#js_external}}
                    <p>{{.}}</p>
                    {{/js_external}}
                    {{#js_local}}
                    <p>{{.}}</p>
                    {{/js_local}}
                    {{^js_local}}{{^js_external}}
                    <p>No JavaScript files found.</p>
                    {{/js_external}}{{/js_local}}
                </div>
            </div>

            <div class="expandible cursor-pointer" onclick="return onToggleExpandible(this)">
                <a>Iframes included</a>

                <div class="expandible-content">
                    {{#iframes}}
                    <p>{{.}}</p>
                    {{/iframes}}
                    {{^iframes}}
                    <p>No iframes found.</p>
                    {{/iframes}}
                </div>
            </div>

            <div class="expandible cursor-pointer" onclick="return onToggleExpandible(this)">
                <a>Embedded objects included</a>

                <div class="expandible-content">
                    {{#plugins}}
                    <p>{{.}}</p>
                    {{/plugins}}
                    {{^plugins}}
                    <p>No plugins found.</p>
                    {{/plugins}}
                </div>
            </div>
            {{/links}}

        </div>
        <div class="lock-content-area" onclick="hideSiteDetails()"></div>

        </div>

    </script>

    <!-- Footer -->

    <?php include("includes/dashboard_footer.php"); ?>

    
  


